# Referring to Internet resources (InternetAccess)

|      Type       |        Scope        | Severity |    Activated<br>by default    |    Minutes<br>to fix    |     Tags     |
|:---------------:|:-------------------:|:--------:|:-----------------------------:|:-----------------------:|:------------:|
| `Vulnerability` |    `BSL`<br>`OS`    | `Major`  |             `No`              |          `60`           | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Description
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Check access to Internet resources and the set of transmitted data to prevent the transfer of confidential or protected information.

## Examples
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
HTTPConnection = New HTTPConnection("zabbix.localhost", 80); // error
FTPConnection = New FTPConnection(Server, Port, User, Pwd); // error
```

## Sources
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Snippets

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Diagnostic ignorance in code

```bsl
// BSLLS:InternetAccess-off
// BSLLS:InternetAccess-on
```

### Parameter for config

```json
"InternetAccess": false
```
