# Reserved parameter names (ReservedParameterNames)

|     Type     |        Scope        | Severity |    Activated<br>by default    |    Minutes<br>to fix    |               Tags                |
|:------------:|:-------------------:|:--------:|:-----------------------------:|:-----------------------:|:---------------------------------:|
| `Code smell` |    `BSL`<br>`OS`    | `Major`  |             `Yes`             |           `5`           |    `standard`<br>`badpractice`    |

## Parameters


|      Name       |   Type   |                    Description                     | Default value |
|:---------------:|:--------:|:--------------------------------------------------:|:-------------:|
| `reservedWords` | `String` | `Regular expression for reserved parameter names.` |      ``       |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Description


If a parameter name matches one of a system enumeration's name, then all values of that enumeration will not be available in the local context.
Module code's syntax checking will not detect an error. To prevent this situation, a parameter name should not match all names of system enumerations.

Parameter names should not contain reserved words such as system enumerations.
The list of reserved words is set by a regular expression.
The search is case-insensitive.

**For example:**

"FormGroupType|FormFieldType"

## Sources
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* Source: [Standard: Procedure and Function Parameters (RU)](https://its.1c.ru/db/v8std/content/640/hdoc)
* Source: [Standard: Rules for generating variable names (RU)](https://its.1c.ru/db/v8std#content:454:hdoc)

## Snippets

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Diagnostic ignorance in code

```bsl
// BSLLS:ReservedParameterNames-off
// BSLLS:ReservedParameterNames-on
```

### Parameter for config

```json
"ReservedParameterNames": {
    "reservedWords": ""
}
```
