# Безумные многострочные литералы (CrazyMultilineString)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                             Теги                             |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `1`                 |       `badpractice`<br>`suspicious`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

В исходном тексте многострочные константы могут задаваться двумя способами:

- 'классический', в котором используется символ переноса строки и конкатенация строк 
- 'странный', при котором строки разделяются пробельными символами

Второй способ усложняет восприятие, при его использовании проще допустить и пропустить ошибку.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Усложняет восприятие:

```bsl
Строка = "ВВВ" "СС"
"Ф";
```

Классический вариант:

```bsl
Строка = "ВВВ" + "СС"
         + "Ф";
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CrazyMultilineString-off
// BSLLS:CrazyMultilineString-on
```

### Параметр конфигурационного файла

```json
"CrazyMultilineString": false
```
