# Запрет экспортных глобальных переменных модуля (ExportVariables)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                         Теги                          |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-----------------------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`design`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В большинстве случаев, вместо переменных программных модулей следует использовать более подходящие средства разработки платформы 1С:Предприятие.
Поскольку область видимости (использования) таких переменных сложно контролировать,
то они зачастую становятся источником трудновоспроизводимых ошибок.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
Перем КонвертацияФайлов Экспорт;

Процедура ПередЗаписью(Отказ)

  Если КонвертацияФайлов Тогда 
  ...

КонецПроцедуры

```

Для передачи параметров между обработчиками подписок на события и в обработчики событий модуля объекта из внешнего кода
рекомендуется использовать свойство объекта ДополнительныеСвойства

```bsl
Процедура ПередЗаписью(Отказ)

  Если ДополнительныеСвойства.Свойство("КонвертацияФайлов") Тогда 
  ...

КонецПроцедуры

// вызывающий код
ФайлОбъект.ДополнительныеСвойства.Вставить("КонвертацияФайлов", Истина);
ФайлОбъект.Записать();
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников -->

[Стандарт: Использование переменных в программных модулях](https://its.1c.ru/db/v8std#content:639:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ExportVariables-off
// BSLLS:ExportVariables-on
```

### Параметр конфигурационного файла

```json
"ExportVariables": false
```
