# Объекту метаданных присвоено запрещенное имя (ForbiddenMetadataName)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                    Теги                     |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:-------------------------------------------:|
| `Ошибка` |             `BSL`             | `Блокирующий` |              `Да`              |                `30`                 |       `standard`<br>`sql`<br>`design`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Запрещено использовать имена объектов метаданных (и их реквизитов и табличных частей), которые применяются при именовании таблиц запросов (например Документ, Справочник).

Использование таких имен может приводить к ошибкам при исполнении запроса, а кроме того, затрудняют использование конструктора запросов и снижают наглядность текста запроса.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Плохое наименование
- `Справочник.Справочник`
- `Справочник.МойСправочник.Реквизит.Документ`
- `РегистрСведений.МойРегистрСведений.Изменение.Документы`

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* [Стандарт: Организация хранения данных. Имя, Синоним, Комментарий](https://its.1c.ru/db/v8std#content:474:hdoc:2.5)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ForbiddenMetadataName-off
// BSLLS:ForbiddenMetadataName-on
```

### Параметр конфигурационного файла

```json
"ForbiddenMetadataName": false
```
