# Обращение к Интернет-ресурсам (InternetAccess)

|     Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Уязвимость` |         `BSL`<br>`OS`         | `Важный` |             `Нет`              |                `60`                 | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Проверьте обращение к Интернет-ресурсам и набор передаваемых данных для исключения передачи конфиденциальной или защищенной информации.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
HTTPСоединение = Новый HTTPСоединение("zabbix.localhost", 80); // замечание
FTPСоединение = Новый FTPСоединение(Сервер, Порт, Пользователь, Пароль); // замечание
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:InternetAccess-off
// BSLLS:InternetAccess-on
```

### Параметр конфигурационного файла

```json
"InternetAccess": false
```
