# Смешивание латинских и кириллических символов в одном идентификаторе (LatinAndCyrillicSymbolInWord)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                 Теги                  |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `5`                 |    `brainoverload`<br>`suspicious`    |

## Параметры


|                  Имя                  |   Тип    |                             Описание                              |                                                                        Значение<br>по умолчанию                                                                        |
|:-------------------------------------:|:--------:|:-----------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
|            `excludeWords`             | `Строка` |     `Список слов-исключений, задается строкой через запятую`      | `ЧтениеXML, ЧтениеJSON, ЗаписьXML, ЗаписьJSON, ComОбъект, ФабрикаXDTO, ОбъектXDTO, СоединениеFTP, HTTPСоединение, HTTPЗапрос, HTTPСервисОтвет, SMSСообщение, WSПрокси` |
| `allowTrailingPartsInAnotherLanguage` | `Булево` | `Разрешить начинать или заканчивать имя со слова на другом языке` |                                                                                 `true`                                                                                 |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

При разработке не стоит использовать идентификаторы, состоящие из символов разных языков, т.к. это усложняет их дальнейшее использование, заставляя переключать раскладку.  
Диагностика обнаруживает и ошибочное использование символов из другого языка, когда он был использован не преднамеренно, например использование символов с одинаковым начертанием `o`, `c`, `B`, `p` и т.д.

Для снижения "шума" на именах состоящих из нескольких слов, начинающихся либо заканчивающихся на слово на другом языке, в диагностику добавлен параметр, включенный по умолчанию.  
Если параметр включен, то **НЕ** считаются ошибочными имена вида `ZebraДрайвер`, `КодHTTP`, `SMSШлюз` и подобные им. 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:LatinAndCyrillicSymbolInWord-off
// BSLLS:LatinAndCyrillicSymbolInWord-on
```

### Параметр конфигурационного файла

```json
"LatinAndCyrillicSymbolInWord": {
    "excludeWords": "ЧтениеXML, ЧтениеJSON, ЗаписьXML, ЗаписьJSON, ComОбъект, ФабрикаXDTO, ОбъектXDTO, СоединениеFTP, HTTPСоединение, HTTPЗапрос, HTTPСервисОтвет, SMSСообщение, WSПрокси",
    "allowTrailingPartsInAnotherLanguage": true
}
```
