# Ошибка разбора текста запроса (QueryParseError)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                       Теги                       |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`sql`<br>`badpractice`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

При написании текста запроса необходимо следовать следующему правилу: текст запроса должен быть написан таким образом, что бы он мог быть открыт конструктором запросов.

Следование этому правилу позволяет осуществлять быструю проверку корректности синтаксиса запроса, а также доработку и сопровождение. 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно

```bsl
ТекстЗапроса = "ВЫБРАТЬ
| Номенклатура.Наименование  КАК Наименование ,
| Номенклатура. " + ИмяПоляКод + " КАК КодАртикул
|ИЗ
| Справочник.Номенклатура КАК Номенклатура";
```

Правильно

```bsl
ТекстЗапроса = "ВЫБРАТЬ
| Номенклатура.Наименование  КАК Наименование ,
| &ИмяПоляЗапроса КАК КодАртикул
|ИЗ
| Справочник.Номенклатура КАК Номенклатура";

ТекстЗапроса = СтрЗаменить(ТекстЗапроса, 
                            "&ИмяПоляКод", 
                            "Номенклатура." + ИмяПоляКод);
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* [Стандарт: Работа с запросами. Оформление текстов запросов](https://its.1c.ru/db/v8std#content:437:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:QueryParseError-off
// BSLLS:QueryParseError-on
```

### Параметр конфигурационного файла

```json
"QueryParseError": false
```
