# Избыточное обращение к объекту (RedundantAccessToObject)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |             Теги             |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------------------------:|
| `Дефект кода` |             `BSL`             | `Информационный` |              `Да`              |                 `1`                 |    `standard`<br>`clumsy`    |

## Параметры


|          Имя           |   Тип    |              Описание              |    Значение<br>по умолчанию    |
|:----------------------:|:--------:|:----------------------------------:|:------------------------------:|
|  `checkObjectModule`   | `Булево` |    `Проверять модули объектов`     |             `true`             |
|   `checkFormModule`    | `Булево` |      `Проверять модули форм`       |             `true`             |
| `checkRecordSetModule` | `Булево` | `Проверять модули наборов записей` |             `true`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
В формах и модулях объектов избыточно обращаться к реквизитам через ЭтотОбъект. В общих модулях избыточно обращаться к методам через свое имя, кроме модулей с ПовтИсп.

## Примеры
В модуле объекта документа с реквизитом `Контрагент` неправильно писать
```bsl
ЭтотОбъект.Контрагент = ПолучитьКонтрагента();
```

правильно будет обратиться к реквизиту напрямую
```bsl
Контрагент = ПолучитьКонтрагента();
```

В общем модуле `ОбщегоНазначения` неправильным будет такой вызов метода
```bsl
ОбщегоНазначения.СообщитьПользователю("ru = 'Привет мир!'");
```

а правильным
```bsl
СообщитьПользователю("ru = 'Привет мир!'");
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:RedundantAccessToObject-off
// BSLLS:RedundantAccessToObject-on
```

### Параметр конфигурационного файла

```json
"RedundantAccessToObject": {
    "checkObjectModule": true,
    "checkFormModule": true,
    "checkRecordSetModule": true
}
```
