# Зарезервированные имена параметров (ReservedParameterNames)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`badpractice`    |

## Параметры


|       Имя       |   Тип    |                           Описание                            |    Значение<br>по умолчанию    |
|:---------------:|:--------:|:-------------------------------------------------------------:|:------------------------------:|
| `reservedWords` | `Строка` | `Регулярное выражение для зарезервированных имен параметров.` |               ``               |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
Если имя параметра совпадает с именем системного перечисления, то невозможно будет обратиться к значениям этого системного перечисления, потому что параметр его скроет.
Синтаксическая проверка кода модуля не выявит такую ошибку. Чтобы предотвратить эту ситуацию имя параметра не должно совпадать с именами системных перечислений.
Список зарезервированных слов задается регулярным выражением.
Поиск производится без учета регистра символов.

**Примеры настройки:**

"ВидГруппыФормы|ВидПоляФормы"

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* Источник: [Стандарт: Параметры процедур и функций](https://its.1c.ru/db/v8std/content/640/hdoc)
* Источник: [Стандарт: Правила образования имен переменных](https://its.1c.ru/db/v8std#content:454:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ReservedParameterNames-off
// BSLLS:ReservedParameterNames-on
```

### Параметр конфигурационного файла

```json
"ReservedParameterNames": {
    "reservedWords": ""
}
```
