# Перезапись параметров метода (RewriteMethodParameter)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `2`                 | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Иногда разработчик пишут функции таким образом, когда аргументы функции перезаписываются сразу на входе в функцию/процедуру. 

Такое поведение вводит в заблуждение других разработчиков, которые вызывают подобные функции/процедуры. 
Эти функции нужно исправить. Например, убрать параметры, преобразовав их в локальные переменные.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
Подозрительный код
```bsl
Процедура Конфигуратор(Знач СтрокаПодключения, Знач Пользователь = "", Знач Пароль = "") Экспорт
  СтрокаПодключения = "/F""" + КаталогБазы + """"; // Здесь
...
КонецФункции
```

Исправленный код
```bsl
Процедура Конфигуратор(Знач КаталогБазы, Знач Пользователь = "", Знач Пароль = "") Экспорт
  СтрокаПодключения = "/F""" + КаталогБазы + """"; // Здесь
...
КонецФункции
```
или
```bsl
Процедура Конфигуратор(Знач КаталогБазы, Знач Пользователь = "", Знач Пароль = "") Экспорт
  Если Не ПустаяСтрока(КаталогБазы) Тогда
   НоваяСтрокаПодключения = "/F""" + КаталогБазы + """";
  Иначе
   НоваяСтрокаПодключения = СтрокаПодключения;
  КонецЕсли;
...
КонецФункции
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* [PVS-Studio V763. Parameter is always rewritten in function body before being used](https://pvs-studio.com/ru/docs/warnings/v6023)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:RewriteMethodParameter-off
// BSLLS:RewriteMethodParameter-on
```

### Параметр конфигурационного файла

```json
"RewriteMethodParameter": false
```
