# Флажок «Устанавливать права для новых объектов» должен быть установлен только у роли ПолныеПрава (SetPermissionsForNewObjects)

|     Тип      |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                        Теги                         |
|:------------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:---------------------------------------------------:|
| `Уязвимость` |             `BSL`             | `Критичный` |              `Да`              |                 `1`                 |       `standard`<br>`badpractice`<br>`design`       |

## Параметры


|          Имя          |   Тип    |               Описание                |    Значение<br>по умолчанию    |
|:---------------------:|:--------:|:-------------------------------------:|:------------------------------:|
| `namesFullAccessRole` | `Строка` | `Наименование роли с полными правами` |    `FullAccess,ПолныеПрава`    |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
При добавлении новой роли может быть ошибочно установлен атрибут "Устанавливать права для новых объектов", что приведет к накоплению в этой роли прав на все добавленные после неё объекты и избыточные права у пользователей с этой ролью.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники

* Источник: [Стандарт: Установка прав для новых объектов и полей объектов](https://its.1c.ru/db/v8std/content/532/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:SetPermissionsForNewObjects-off
// BSLLS:SetPermissionsForNewObjects-on
```

### Параметр конфигурационного файла

```json
"SetPermissionsForNewObjects": {
    "namesFullAccessRole": "FullAccess,ПолныеПрава"
}
```
