# Использование привилегированного режима (SetPrivilegedMode)

|            Тип             |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:--------------------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Потенциальная уязвимость` |             `BSL`             | `Важный` |              `Да`              |                 `1`                 | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Текущее правило находит код установки привилегированного режима.
Для внешнего кода, например, кода из внешних отчетов\обработок, это действие может быть небезопасным.

По найденным замечаниям необходимо выполнить ручной аудит кода на предмет его правильности и безопасности.

Правило находит вызовы метода `УстановитьПривилегированныйРежим`
  вызов `УстановитьПривилегированныйРежим(Ложь)` игнорируется

Потенциально опасны любые экспортные процедуры и функции, которые выполняют на сервере какие-либо действия с предварительной безусловной установкой привилегированного режима, так как это отключает проверку прав доступа текущего пользователя. Особого внимания требуют экспортные процедуры и функции клиентского прикладного программного интерфейса сервера 1С:Предприятия.

Например, неправильно:
```bsl
Процедура ИзменитьИлиУдалитьДанные(...) Экспорт

УстановитьПривилегированныйРежим(Истина); // Отключаем проверку прав доступа
// Изменяем данные в привилегированном режиме
...
КонецПроцедуры
```
Правильно:
```bsl
Процедура ИзменитьИлиУдалитьДанные(...) Экспорт

// Изменяем данные
// (при этом если у пользователя недостаточно прав для выполнения операции над данными, то будет вызвано исключение)
...

КонецПроцедуры
```
Исключение составляют случаи, когда действие, выполняемое процедурой, должно быть разрешено (или возвращаемое значение функции должно быть доступно) абсолютно всем категориям пользователей.

Если все-таки необходимо использовать привилегированный режим внутри метода, следует использовать проверку прав доступа вручную, следует использовать метод `ВыполнитьПроверкуПравДоступа`.

Пример предварительной проверки перед выполнением действий в привилегированном режиме:
```bsl
Процедура ИзменитьИлиУдалитьДанные(...) Экспорт

ВыполнитьПроверкуПравДоступа(...); // Если у пользователя недостаточно прав, то будет вызвано исключение
УстановитьПривилегированныйРежим(Истина); // Отключаем проверку прав доступа

// Изменяем данные в привилегированном режиме
...
КонецПроцедуры
```
## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
    УстановитьПривилегированныйРежим(Истина); // есть замечание

    Значение = Истина;
    УстановитьПривилегированныйРежим(Значение); // есть замечание

    УстановитьПривилегированныйРежим(Ложь); // нет замечания
```
## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* Источник: [Стандарт: Использование привилегированного режима](https://its.1c.ru/db/v8std/content/485/hdoc)
* Источник: [Стандарт: Безопасность прикладного программного интерфейса сервера](https://its.1c.ru/db/v8std#content:678:hdoc)
* Источник: [Стандарт: Ограничение на выполнение «внешнего» кода](https://its.1c.ru/db/v8std/content/669/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:SetPrivilegedMode-off
// BSLLS:SetPrivilegedMode-on
```

### Параметр конфигурационного файла

```json
"SetPrivilegedMode": false
```
