/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import lombok.Generated;
import org.eclipse.lsp4j.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AutoServerInfo
extends ServerInfo
implements Serializable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoServerInfo.class);
    private static final String MANIFEST_VERSION = AutoServerInfo.readVersion();
    @Value(value="${spring.application.name:Dummy Language Server}")
    private transient String applicationName = "";

    @PostConstruct
    private void init() {
        this.setName(this.applicationName);
        this.setVersion(MANIFEST_VERSION);
    }

    private static String readVersion() {
        InputStream mfStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        try {
            manifest.read(mfStream);
        }
        catch (IOException e) {
            LOGGER.error("Can't read manifest", (Throwable)e);
            return "";
        }
        return manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoServerInfo)) {
            return false;
        }
        AutoServerInfo other = (AutoServerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoServerInfo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

