/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

@EnableAutoConfiguration
@ComponentScan(value={"com.github._1c_syntax.bsl.languageserver"})
@EnableCaching(proxyTargetClass=true)
public class BSLLSBinding {
    private static final AtomicReference<Object> application = new AtomicReference();
    private static final AtomicReference<Object> context = new AtomicReference();

    public static ConfigurableApplicationContext getApplicationContext() {
        ConfigurableApplicationContext context = BSLLSBinding.getContext();
        if (!context.isActive()) {
            context = BSLLSBinding.createContext();
        }
        return context;
    }

    public static Collection<DiagnosticInfo> getDiagnosticInfos() {
        return (Collection)BSLLSBinding.getApplicationContext().getBean("diagnosticInfos", Collection.class);
    }

    public static LanguageServerConfiguration getLanguageServerConfiguration() {
        return (LanguageServerConfiguration)BSLLSBinding.getApplicationContext().getBean(LanguageServerConfiguration.class);
    }

    public static ServerContext getServerContext() {
        return (ServerContext)BSLLSBinding.getApplicationContext().getBean(ServerContext.class);
    }

    private static SpringApplication createApplication() {
        SpringApplication app = new SpringApplicationBuilder(new Class[]{BSLLSBinding.class}).bannerMode(Banner.Mode.OFF).web(WebApplicationType.NONE).logStartupInfo(false).resourceLoader((ResourceLoader)new DefaultResourceLoader(BSLLSBinding.class.getClassLoader())).lazyInitialization(true).properties(Map.of("app.command.line.runner.enabled", "false", "app.scheduling.enabled", "false", "spring.cache.caffeine.spec", "maximumSize=500,expireAfterAccess=600s", "spring.cache.cache-names", "testIds,testSources")).build();
        app.setRegisterShutdownHook(false);
        return app;
    }

    private static ConfigurableApplicationContext createContext() {
        return BSLLSBinding.getApplication().run(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static SpringApplication getApplication() {
        Object $value = application.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = application;
            synchronized (atomicReference) {
                $value = application.get();
                if ($value == null) {
                    SpringApplication actualValue = BSLLSBinding.createApplication();
                    $value = actualValue == null ? application : actualValue;
                    application.set($value);
                }
            }
        }
        return (SpringApplication)($value == application ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static ConfigurableApplicationContext getContext() {
        Object $value = context.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = context;
            synchronized (atomicReference) {
                $value = context.get();
                if ($value == null) {
                    ConfigurableApplicationContext actualValue = BSLLSBinding.createContext();
                    $value = actualValue == null ? context : actualValue;
                    context.set($value);
                }
            }
        }
        return (ConfigurableApplicationContext)($value == context ? null : $value);
    }
}

