/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public class WorkDoneProgressHelper {
    private final LanguageClientHolder languageClientHolder;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private boolean isWorkDoneProgressSupported;

    public WorkDoneProgressReporter createProgress(int size, String messagePostfix) {
        this.isWorkDoneProgressSupported = this.clientCapabilitiesHolder.getCapabilities().map(ClientCapabilities::getWindow).map(WindowClientCapabilities::getWorkDoneProgress).orElse(false);
        if (!this.isWorkDoneProgressSupported) {
            return new WorkDoneProgressReporter("", 0, "");
        }
        String token = UUID.randomUUID().toString();
        WorkDoneProgressCreateParams createProgressParams = new WorkDoneProgressCreateParams(Either.forLeft((Object)token));
        this.languageClientHolder.execIfConnected(languageClient -> languageClient.createProgress(createProgressParams));
        return new WorkDoneProgressReporter(token, size, messagePostfix);
    }

    @ConstructorProperties(value={"languageClientHolder", "clientCapabilitiesHolder"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WorkDoneProgressHelper(LanguageClientHolder languageClientHolder, ClientCapabilitiesHolder clientCapabilitiesHolder) {
        this.languageClientHolder = languageClientHolder;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
    }

    public class WorkDoneProgressReporter {
        private final String token;
        private int size;
        private final String messagePostfix;
        private final AtomicInteger counter = new AtomicInteger();

        public void beginProgress(String title) {
            if (!WorkDoneProgressHelper.this.isWorkDoneProgressSupported) {
                return;
            }
            WorkDoneProgressHelper.this.languageClientHolder.execIfConnected(languageClient -> {
                WorkDoneProgressBegin value = new WorkDoneProgressBegin();
                value.setTitle(title);
                ProgressParams params = new ProgressParams(Either.forLeft((Object)this.token), Either.forLeft((Object)value));
                languageClient.notifyProgress(params);
            });
        }

        public void tick(String message, int percentage) {
            if (!WorkDoneProgressHelper.this.isWorkDoneProgressSupported) {
                return;
            }
            WorkDoneProgressHelper.this.languageClientHolder.execIfConnected(languageClient -> {
                WorkDoneProgressReport value = new WorkDoneProgressReport();
                value.setMessage(message);
                value.setCancellable(Boolean.valueOf(false));
                value.setPercentage(Integer.valueOf(percentage));
                ProgressParams params = new ProgressParams(Either.forLeft((Object)this.token), Either.forLeft((Object)value));
                languageClient.notifyProgress(params);
            });
        }

        public void tick() {
            if (!WorkDoneProgressHelper.this.isWorkDoneProgressSupported) {
                return;
            }
            int currentCounter = this.counter.incrementAndGet();
            String message = String.format("%d/%d%s", currentCounter, this.size, this.messagePostfix);
            double percentage = (double)currentCounter / (double)this.size * 100.0;
            this.tick(message, (int)percentage);
        }

        public void endProgress(String message) {
            if (!WorkDoneProgressHelper.this.isWorkDoneProgressSupported) {
                return;
            }
            WorkDoneProgressHelper.this.languageClientHolder.execIfConnected(languageClient -> {
                WorkDoneProgressEnd value = new WorkDoneProgressEnd();
                value.setMessage(message);
                ProgressParams params = new ProgressParams(Either.forLeft((Object)this.token), Either.forLeft((Object)value));
                languageClient.notifyProgress(params);
            });
        }

        @ConstructorProperties(value={"token", "size", "messagePostfix"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WorkDoneProgressReporter(String token, int size, String messagePostfix) {
            this.token = token;
            this.size = size;
            this.messagePostfix = messagePostfix;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setSize(int size) {
            this.size = size;
        }
    }
}

