/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cli;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.MetricStorage;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.reporters.ReportersAggregator;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@CommandLine.Command(name="analyze", aliases={"-a", "--analyze"}, description={"Run analysis and get diagnostic info"}, usageHelpAutoWidth=true, footer={"@|green Copyright(c) 2018-2025|@"})
@Component
public class AnalyzeCommand
implements Callable<Integer> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeCommand.class);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-w", "--workspaceDir"}, description={"Workspace directory"}, paramLabel="<path>", defaultValue="")
    private String workspaceDirOption;
    @CommandLine.Option(names={"-s", "--srcDir"}, description={"Source directory"}, paramLabel="<path>", defaultValue="")
    private String srcDirOption;
    @CommandLine.Option(names={"-o", "--outputDir"}, description={"Output report directory"}, paramLabel="<path>", defaultValue="")
    private String outputDirOption;
    @CommandLine.Option(names={"-c", "--configuration"}, description={"Path to language server configuration file"}, paramLabel="<path>", defaultValue="")
    private String configurationOption;
    @CommandLine.Option(names={"-r", "--reporter"}, paramLabel="<keys>", completionCandidates=ReportersKeys.class, description={"Reporter key (${COMPLETION-CANDIDATES})"})
    private String[] reportersOptions = new String[0];
    @CommandLine.Option(names={"-q", "--silent"}, description={"Silent mode"})
    private boolean silentMode;
    private final ReportersAggregator aggregator;
    private final LanguageServerConfiguration configuration;
    private final ServerContext context;

    @Override
    public Integer call() {
        Integer n;
        Path workspaceDir = Absolute.path((String)this.workspaceDirOption);
        if (!workspaceDir.toFile().exists()) {
            LOGGER.error("Workspace dir `{}` is not exists", (Object)workspaceDir);
            n = 1;
        } else {
            Path srcDir = Absolute.path((String)this.srcDirOption);
            if (!srcDir.toFile().exists()) {
                LOGGER.error("Source dir `{}` is not exists", (Object)srcDir);
                n = 1;
            } else {
                List<FileInfo> fileInfos;
                File configurationFile = new File(this.configurationOption);
                if (configurationFile.exists()) {
                    this.configuration.update(configurationFile);
                }
                Path configurationPath = LanguageServerConfiguration.getCustomConfigurationRoot(this.configuration, srcDir);
                this.context.setConfigurationRoot(configurationPath);
                List files = (List)FileUtils.listFiles((File)srcDir.toFile(), (String[])new String[]{"bsl", "os"}, (boolean)true);
                this.context.populateContext(files);
                if (this.silentMode) {
                    fileInfos = files.parallelStream().map(file -> this.getFileInfoFromFile(workspaceDir, (File)file)).collect(Collectors.toList());
                } else {
                    try (ProgressBar pb = new ProgressBarBuilder().setTaskName("Analyzing files...").setInitialMax((long)files.size()).setStyle(ProgressBarStyle.ASCII).build();){
                        fileInfos = files.parallelStream().map(file -> {
                            pb.step();
                            return this.getFileInfoFromFile(workspaceDir, (File)file);
                        }).collect(Collectors.toList());
                    }
                }
                AnalysisInfo analysisInfo = new AnalysisInfo(LocalDateTime.now(), fileInfos, srcDir.toString());
                Path outputDir = Absolute.path((String)this.outputDirOption);
                this.aggregator.report(analysisInfo, outputDir);
                n = 0;
            }
        }
        MeasuresAspect.aspectOf().printMeasures();
        return n;
    }

    public String[] getReportersOptions() {
        return (String[])this.reportersOptions.clone();
    }

    private FileInfo getFileInfoFromFile(Path srcDir, File file) {
        DocumentContext documentContext = this.context.addDocument(file.toURI());
        this.context.rebuildDocument(documentContext);
        Path filePath = srcDir.relativize(Absolute.path((File)file));
        List<Diagnostic> diagnostics = documentContext.getDiagnostics();
        MetricStorage metrics = documentContext.getMetrics();
        String mdoRef = documentContext.getMdObject().map(MD::getMdoReference).map(MdoReference::getMdoRef).orElse("");
        FileInfo fileInfo = new FileInfo(filePath, mdoRef, diagnostics, metrics);
        this.context.tryClearDocument(documentContext);
        return fileInfo;
    }

    @ConstructorProperties(value={"aggregator", "configuration", "context"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnalyzeCommand(ReportersAggregator aggregator, LanguageServerConfiguration configuration, ServerContext context) {
        this.aggregator = aggregator;
        this.configuration = configuration;
        this.context = context;
    }

    private static class ReportersKeys
    extends ArrayList<String> {
        ReportersKeys(ReportersAggregator aggregator) {
            super(aggregator.reporterKeys());
        }
    }
}

