/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.DefaultCodeLensData;
import com.github._1c_syntax.bsl.languageserver.commands.complexity.AbstractToggleComplexityInlayHintsCommandSupplier;
import com.github._1c_syntax.bsl.languageserver.commands.complexity.ToggleComplexityInlayHintsCommandArguments;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractMethodComplexityCodeLensSupplier
implements CodeLensSupplier<ComplexityCodeLensData> {
    private static final String TITLE_KEY = "title";
    private static final int DEFAULT_COMPLEXITY_THRESHOLD = -1;
    protected final LanguageServerConfiguration configuration;
    private final AbstractToggleComplexityInlayHintsCommandSupplier commandSupplier;

    @Override
    public List<CodeLens> getCodeLenses(DocumentContext documentContext) {
        int complexityThreshold = this.getComplexityThreshold();
        Map<MethodSymbol, Integer> methodsComplexity = this.getMethodsComplexity(documentContext);
        return documentContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodsComplexity.getOrDefault(methodSymbol, complexityThreshold - 1) >= complexityThreshold).map(methodSymbol -> this.toCodeLens((MethodSymbol)methodSymbol, documentContext)).collect(Collectors.toList());
    }

    @Override
    public CodeLens resolve(DocumentContext documentContext, CodeLens unresolved, ComplexityCodeLensData data) {
        String methodName = data.getMethodName();
        Map<MethodSymbol, Integer> methodsComplexity = this.getMethodsComplexity(documentContext);
        documentContext.getSymbolTree().getMethodSymbol(methodName).ifPresent(methodSymbol -> {
            int complexity = (Integer)methodsComplexity.get(methodSymbol);
            String title = Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), TITLE_KEY, complexity);
            ToggleComplexityInlayHintsCommandArguments arguments = new ToggleComplexityInlayHintsCommandArguments(this.commandSupplier.getId(), data);
            Command command = this.commandSupplier.createCommand(title, arguments);
            unresolved.setCommand(command);
        });
        return unresolved;
    }

    @Override
    public Class<ComplexityCodeLensData> getCodeLensDataClass() {
        return ComplexityCodeLensData.class;
    }

    protected abstract Map<MethodSymbol, Integer> getMethodsComplexity(DocumentContext var1);

    private int getComplexityThreshold() {
        Either<Boolean, Map<String, Object>> parameters = this.configuration.getCodeLensOptions().getParameters().getOrDefault(this.getId(), (Either<Boolean, Map<String, Object>>)Either.forLeft((Object)true));
        if (parameters.isLeft()) {
            return -1;
        }
        return ((Map)parameters.getRight()).getOrDefault("complexityThreshold", -1);
    }

    private CodeLens toCodeLens(MethodSymbol methodSymbol, DocumentContext documentContext) {
        ComplexityCodeLensData data = new ComplexityCodeLensData(documentContext.getUri(), this.getId(), methodSymbol.getName());
        CodeLens codeLens = new CodeLens(methodSymbol.getSubNameRange());
        codeLens.setData((Object)data);
        return codeLens;
    }

    @ConstructorProperties(value={"configuration", "commandSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractMethodComplexityCodeLensSupplier(LanguageServerConfiguration configuration, AbstractToggleComplexityInlayHintsCommandSupplier commandSupplier) {
        this.configuration = configuration;
        this.commandSupplier = commandSupplier;
    }

    public static final class ComplexityCodeLensData
    extends DefaultCodeLensData {
        private final String methodName;

        @ConstructorProperties(value={"uri", "id", "methodName"})
        public ComplexityCodeLensData(URI uri, String id, String methodName) {
            super(uri, id);
            this.methodName = methodName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComplexityCodeLensData)) {
                return false;
            }
            ComplexityCodeLensData other = (ComplexityCodeLensData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComplexityCodeLensData;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            return result;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbstractMethodComplexityCodeLensSupplier.ComplexityCodeLensData(super=" + super.toString() + ", methodName=" + this.getMethodName() + ")";
        }
    }
}

