/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.events.LanguageServerInitializeRequestReceivedEvent;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.InitializeParams;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;

@CacheConfig(cacheNames={"testSources"})
public abstract class AbstractRunTestsCodeLensSupplier<T extends CodeLensData>
implements CodeLensSupplier<T> {
    protected final LanguageServerConfiguration configuration;
    private boolean clientIsSupported;

    @EventListener
    @CacheEvict(allEntries=true)
    public void handleEvent(LanguageServerInitializeRequestReceivedEvent event) {
        String clientName = Optional.of(event).map(LanguageServerInitializeRequestReceivedEvent::getParams).map(InitializeParams::getClientInfo).map(ClientInfo::getName).orElse("");
        this.clientIsSupported = "Visual Studio Code".equals(clientName);
    }

    @EventListener
    @CacheEvict(allEntries=true)
    public void handleLanguageServerConfigurationChange(LanguageServerConfigurationChangedEvent event) {
    }

    @Override
    public boolean isApplicable(DocumentContext documentContext) {
        URI uri = documentContext.getUri();
        Set<URI> testSources = this.getSelf().getTestSources(documentContext.getServerContext().getConfigurationRoot());
        return this.clientIsSupported && documentContext.getFileType() == FileType.OS && testSources.stream().anyMatch(testSource -> AbstractRunTestsCodeLensSupplier.isInside(uri, testSource));
    }

    protected abstract AbstractRunTestsCodeLensSupplier<T> getSelf();

    @Cacheable
    public Set<URI> getTestSources(@Nullable Path configurationRoot) {
        String configurationRootString = Optional.ofNullable(configurationRoot).map(Path::toString).orElse("");
        return this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions().getTestSources().stream().map(testDir -> Path.of(configurationRootString, testDir)).map(path -> Absolute.path((Path)path).toUri()).collect(Collectors.toSet());
    }

    private static boolean isInside(URI childURI, URI parentURI) {
        return !parentURI.relativize(childURI).isAbsolute();
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractRunTestsCodeLensSupplier(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

