/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codelenses;

import com.github._1c_syntax.bsl.languageserver.codelenses.AbstractRunTestsCodeLensSupplier;
import com.github._1c_syntax.bsl.languageserver.codelenses.DefaultCodeLensData;
import com.github._1c_syntax.bsl.languageserver.codelenses.testrunner.TestRunnerAdapter;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.TestRunnerAdapterOptions;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RunAllTestsCodeLensSupplier
extends AbstractRunTestsCodeLensSupplier<DefaultCodeLensData> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RunAllTestsCodeLensSupplier.class);
    private static final String COMMAND_ID = "language-1c-bsl.languageServer.runAllTests";
    private final TestRunnerAdapter testRunnerAdapter;
    private final Resources resources;
    @Autowired
    @Lazy
    private RunAllTestsCodeLensSupplier self;

    public RunAllTestsCodeLensSupplier(LanguageServerConfiguration configuration, TestRunnerAdapter testRunnerAdapter, Resources resources) {
        super(configuration);
        this.testRunnerAdapter = testRunnerAdapter;
        this.resources = resources;
    }

    @Override
    public List<CodeLens> getCodeLenses(DocumentContext documentContext) {
        List<String> testIds = this.testRunnerAdapter.getTestIds(documentContext);
        if (testIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<MethodSymbol> methods = documentContext.getSymbolTree().getMethods();
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        MethodSymbol firstMethod = methods.get(0);
        return List.of(this.toCodeLens(firstMethod, documentContext));
    }

    @Override
    public CodeLens resolve(DocumentContext documentContext, CodeLens unresolved, DefaultCodeLensData data) {
        Path path = Paths.get(documentContext.getUri());
        TestRunnerAdapterOptions options = this.configuration.getCodeLensOptions().getTestRunnerAdapterOptions();
        String executable = options.getExecutableForCurrentOS();
        Object runText = executable + " " + options.getRunAllTestsArguments();
        runText = String.format((String)runText, path);
        Command command = new Command();
        command.setTitle(this.resources.getResourceString(this.getClass(), "runAllTests"));
        command.setCommand(COMMAND_ID);
        command.setArguments(List.of(Map.of("text", runText)));
        unresolved.setCommand(command);
        return unresolved;
    }

    @Override
    public Class<DefaultCodeLensData> getCodeLensDataClass() {
        return DefaultCodeLensData.class;
    }

    private CodeLens toCodeLens(MethodSymbol method, DocumentContext documentContext) {
        DefaultCodeLensData codeLensData = new DefaultCodeLensData(documentContext.getUri(), this.getId());
        CodeLens codeLens = new CodeLens(method.getSubNameRange());
        codeLens.setData((Object)codeLensData);
        return codeLens;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RunAllTestsCodeLensSupplier getSelf() {
        return this.self;
    }
}

