/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.commands;

import com.github._1c_syntax.bsl.languageserver.commands.CommandArguments;
import java.beans.Introspector;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Command;

public interface CommandSupplier<T extends CommandArguments> {
    public static final String COMMAND_SUPPLIER_SUFFIX = "CommandSupplier";

    default public String getId() {
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.endsWith(COMMAND_SUPPLIER_SUFFIX)) {
            simpleName = simpleName.substring(0, simpleName.length() - COMMAND_SUPPLIER_SUFFIX.length());
            simpleName = Introspector.decapitalize(simpleName);
        }
        return simpleName;
    }

    default public Command createCommand(String title, T arguments) {
        return new Command(title, this.getId(), List.of(arguments));
    }

    public Class<T> getCommandArgumentsClass();

    public Optional<Object> execute(T var1);

    default public boolean needRefreshInlayHintsAfterExecuteCommand() {
        return false;
    }

    default public boolean needRefreshCodeLensesAfterExecuteCommand() {
        return false;
    }
}

