/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.github._1c_syntax.bsl.languageserver.aop.EventPublisherAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.SendErrorsMode;
import com.github._1c_syntax.bsl.languageserver.configuration.codelens.CodeLensOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.DiagnosticsOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.documentlink.DocumentLinkOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.formating.FormattingOptions;
import com.github._1c_syntax.bsl.languageserver.configuration.inlayhints.InlayHintOptions;
import com.github._1c_syntax.utils.Absolute;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Role;
import org.springframework.stereotype.Component;

@Component
@Role(value=2)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LanguageServerConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private static final Pattern searchConfiguration;
    private Language language = Language.DEFAULT_LANGUAGE;
    @JsonProperty(value="diagnostics")
    private DiagnosticsOptions diagnosticsOptions = new DiagnosticsOptions();
    @JsonProperty(value="codeLens")
    private CodeLensOptions codeLensOptions = new CodeLensOptions();
    @JsonProperty(value="documentLink")
    private DocumentLinkOptions documentLinkOptions = new DocumentLinkOptions();
    @JsonProperty(value="inlayHint")
    private InlayHintOptions inlayHintOptions = new InlayHintOptions();
    @JsonProperty(value="formatting")
    private FormattingOptions formattingOptions = new FormattingOptions();
    private String siteRoot = "https://1c-syntax.github.io/bsl-language-server";
    private boolean useDevSite;
    private SendErrorsMode sendErrors = SendErrorsMode.DEFAULT;
    @Nullable
    private File traceLog;
    @Nullable
    private Path configurationRoot;
    @JsonIgnore
    private File configurationFile;
    @Value(value="${app.configuration.path:.bsl-language-server.json}")
    @JsonIgnore
    private String configurationFilePath;
    @Value(value="${app.globalConfiguration.path:${user.home}/.bsl-language-server.json}")
    @JsonIgnore
    private String globalConfigPath;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @PostConstruct
    private void init() {
        this.configurationFile = new File(this.configurationFilePath);
        if (this.configurationFile.exists()) {
            this.loadConfigurationFile(this.configurationFile);
            return;
        }
        File configuration = new File(this.globalConfigPath);
        if (configuration.exists()) {
            this.loadConfigurationFile(configuration);
        }
    }

    public void update(File configurationFile) {
        File file = configurationFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file);
        this.loadConfigurationFile(configurationFile);
        EventPublisherAspect.aspectOf().languageServerConfigurationUpdated(joinPoint);
    }

    public void reset() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        this.copyPropertiesFrom(new LanguageServerConfiguration());
        EventPublisherAspect.aspectOf().languageServerConfigurationUpdated(joinPoint);
    }

    public static Path getCustomConfigurationRoot(LanguageServerConfiguration configuration, Path srcDir) {
        File fileConfiguration;
        Path rootPath = null;
        Path pathFromConfiguration = configuration.getConfigurationRoot();
        if (pathFromConfiguration == null) {
            rootPath = Absolute.path((Path)srcDir);
        } else {
            Path absoluteSrcDir = Absolute.path((Path)srcDir);
            Path absolutePathFromConfiguration = Absolute.path((Path)pathFromConfiguration);
            if (absolutePathFromConfiguration.startsWith(absoluteSrcDir)) {
                rootPath = absolutePathFromConfiguration;
            }
        }
        if (rootPath != null && (fileConfiguration = LanguageServerConfiguration.getConfigurationFile(rootPath)) != null) {
            rootPath = fileConfiguration.getAbsolutePath().endsWith(".mdo") ? (Path)Optional.of(fileConfiguration.toPath()).map(Path::getParent).map(Path::getParent).map(Path::getParent).orElse(null) : (Path)Optional.of(fileConfiguration.toPath()).map(Path::getParent).orElse(null);
        }
        return rootPath;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive")
    private static File getConfigurationFile(Path rootPath) {
        File configurationFile = null;
        List<Object> listPath = new ArrayList();
        try (Stream<Path> stream = Files.find(rootPath, 50, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && searchConfiguration.matcher(path.getFileName().toString()).find(), new FileVisitOption[0]);){
            listPath = stream.toList();
        }
        catch (IOException e) {
            LOGGER.error("Error on read configuration file", (Throwable)e);
        }
        if (!listPath.isEmpty()) {
            configurationFile = ((Path)listPath.get(0)).toFile();
        }
        return configurationFile;
    }

    private void loadConfigurationFile(File configurationFile) {
        LanguageServerConfiguration configuration;
        if (!configurationFile.exists()) {
            return;
        }
        JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
        try {
            configuration = (LanguageServerConfiguration)mapper.readValue(configurationFile, LanguageServerConfiguration.class);
        }
        catch (IOException e) {
            LOGGER.error("Can't deserialize configuration file", (Throwable)e);
            return;
        }
        this.configurationFile = configurationFile;
        this.copyPropertiesFrom(configuration);
    }

    private void copyPropertiesFrom(LanguageServerConfiguration configuration) {
        PropertyUtils.copyProperties((Object)this, (Object)configuration);
        PropertyUtils.copyProperties((Object)this.inlayHintOptions, (Object)configuration.inlayHintOptions);
        PropertyUtils.copyProperties((Object)this.codeLensOptions, (Object)configuration.codeLensOptions);
        PropertyUtils.copyProperties((Object)this.diagnosticsOptions, (Object)configuration.diagnosticsOptions);
        PropertyUtils.copyProperties((Object)this.documentLinkOptions, (Object)configuration.documentLinkOptions);
        PropertyUtils.copyProperties((Object)this.formattingOptions, (Object)configuration.formattingOptions);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsOptions getDiagnosticsOptions() {
        return this.diagnosticsOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeLensOptions getCodeLensOptions() {
        return this.codeLensOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentLinkOptions getDocumentLinkOptions() {
        return this.documentLinkOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InlayHintOptions getInlayHintOptions() {
        return this.inlayHintOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FormattingOptions getFormattingOptions() {
        return this.formattingOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSiteRoot() {
        return this.siteRoot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseDevSite() {
        return this.useDevSite;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SendErrorsMode getSendErrors() {
        return this.sendErrors;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public File getTraceLog() {
        return this.traceLog;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getConfigurationRoot() {
        return this.configurationRoot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public File getConfigurationFile() {
        return this.configurationFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSiteRoot(String siteRoot) {
        this.siteRoot = siteRoot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseDevSite(boolean useDevSite) {
        this.useDevSite = useDevSite;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSendErrors(SendErrorsMode sendErrors) {
        this.sendErrors = sendErrors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTraceLog(@Nullable File traceLog) {
        this.traceLog = traceLog;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationRoot(@Nullable Path configurationRoot) {
        this.configurationRoot = configurationRoot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageServerConfiguration)) {
            return false;
        }
        LanguageServerConfiguration other = (LanguageServerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseDevSite() != other.isUseDevSite()) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        DiagnosticsOptions this$diagnosticsOptions = this.getDiagnosticsOptions();
        DiagnosticsOptions other$diagnosticsOptions = other.getDiagnosticsOptions();
        if (this$diagnosticsOptions == null ? other$diagnosticsOptions != null : !((Object)this$diagnosticsOptions).equals(other$diagnosticsOptions)) {
            return false;
        }
        CodeLensOptions this$codeLensOptions = this.getCodeLensOptions();
        CodeLensOptions other$codeLensOptions = other.getCodeLensOptions();
        if (this$codeLensOptions == null ? other$codeLensOptions != null : !((Object)this$codeLensOptions).equals(other$codeLensOptions)) {
            return false;
        }
        DocumentLinkOptions this$documentLinkOptions = this.getDocumentLinkOptions();
        DocumentLinkOptions other$documentLinkOptions = other.getDocumentLinkOptions();
        if (this$documentLinkOptions == null ? other$documentLinkOptions != null : !((Object)this$documentLinkOptions).equals(other$documentLinkOptions)) {
            return false;
        }
        InlayHintOptions this$inlayHintOptions = this.getInlayHintOptions();
        InlayHintOptions other$inlayHintOptions = other.getInlayHintOptions();
        if (this$inlayHintOptions == null ? other$inlayHintOptions != null : !((Object)this$inlayHintOptions).equals(other$inlayHintOptions)) {
            return false;
        }
        FormattingOptions this$formattingOptions = this.getFormattingOptions();
        FormattingOptions other$formattingOptions = other.getFormattingOptions();
        if (this$formattingOptions == null ? other$formattingOptions != null : !((Object)this$formattingOptions).equals(other$formattingOptions)) {
            return false;
        }
        String this$siteRoot = this.getSiteRoot();
        String other$siteRoot = other.getSiteRoot();
        if (this$siteRoot == null ? other$siteRoot != null : !this$siteRoot.equals(other$siteRoot)) {
            return false;
        }
        SendErrorsMode this$sendErrors = this.getSendErrors();
        SendErrorsMode other$sendErrors = other.getSendErrors();
        if (this$sendErrors == null ? other$sendErrors != null : !((Object)((Object)this$sendErrors)).equals((Object)other$sendErrors)) {
            return false;
        }
        File this$traceLog = this.getTraceLog();
        File other$traceLog = other.getTraceLog();
        if (this$traceLog == null ? other$traceLog != null : !((Object)this$traceLog).equals(other$traceLog)) {
            return false;
        }
        Path this$configurationRoot = this.getConfigurationRoot();
        Path other$configurationRoot = other.getConfigurationRoot();
        if (this$configurationRoot == null ? other$configurationRoot != null : !((Object)this$configurationRoot).equals(other$configurationRoot)) {
            return false;
        }
        File this$configurationFile = this.getConfigurationFile();
        File other$configurationFile = other.getConfigurationFile();
        if (this$configurationFile == null ? other$configurationFile != null : !((Object)this$configurationFile).equals(other$configurationFile)) {
            return false;
        }
        String this$configurationFilePath = this.configurationFilePath;
        String other$configurationFilePath = other.configurationFilePath;
        if (this$configurationFilePath == null ? other$configurationFilePath != null : !this$configurationFilePath.equals(other$configurationFilePath)) {
            return false;
        }
        String this$globalConfigPath = this.globalConfigPath;
        String other$globalConfigPath = other.globalConfigPath;
        return !(this$globalConfigPath == null ? other$globalConfigPath != null : !this$globalConfigPath.equals(other$globalConfigPath));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LanguageServerConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseDevSite() ? 79 : 97);
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        DiagnosticsOptions $diagnosticsOptions = this.getDiagnosticsOptions();
        result = result * 59 + ($diagnosticsOptions == null ? 43 : ((Object)$diagnosticsOptions).hashCode());
        CodeLensOptions $codeLensOptions = this.getCodeLensOptions();
        result = result * 59 + ($codeLensOptions == null ? 43 : ((Object)$codeLensOptions).hashCode());
        DocumentLinkOptions $documentLinkOptions = this.getDocumentLinkOptions();
        result = result * 59 + ($documentLinkOptions == null ? 43 : ((Object)$documentLinkOptions).hashCode());
        InlayHintOptions $inlayHintOptions = this.getInlayHintOptions();
        result = result * 59 + ($inlayHintOptions == null ? 43 : ((Object)$inlayHintOptions).hashCode());
        FormattingOptions $formattingOptions = this.getFormattingOptions();
        result = result * 59 + ($formattingOptions == null ? 43 : ((Object)$formattingOptions).hashCode());
        String $siteRoot = this.getSiteRoot();
        result = result * 59 + ($siteRoot == null ? 43 : $siteRoot.hashCode());
        SendErrorsMode $sendErrors = this.getSendErrors();
        result = result * 59 + ($sendErrors == null ? 43 : ((Object)((Object)$sendErrors)).hashCode());
        File $traceLog = this.getTraceLog();
        result = result * 59 + ($traceLog == null ? 43 : ((Object)$traceLog).hashCode());
        Path $configurationRoot = this.getConfigurationRoot();
        result = result * 59 + ($configurationRoot == null ? 43 : ((Object)$configurationRoot).hashCode());
        File $configurationFile = this.getConfigurationFile();
        result = result * 59 + ($configurationFile == null ? 43 : ((Object)$configurationFile).hashCode());
        String $configurationFilePath = this.configurationFilePath;
        result = result * 59 + ($configurationFilePath == null ? 43 : $configurationFilePath.hashCode());
        String $globalConfigPath = this.globalConfigPath;
        result = result * 59 + ($globalConfigPath == null ? 43 : $globalConfigPath.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LanguageServerConfiguration(language=" + String.valueOf((Object)this.getLanguage()) + ", diagnosticsOptions=" + String.valueOf(this.getDiagnosticsOptions()) + ", codeLensOptions=" + String.valueOf(this.getCodeLensOptions()) + ", documentLinkOptions=" + String.valueOf(this.getDocumentLinkOptions()) + ", inlayHintOptions=" + String.valueOf(this.getInlayHintOptions()) + ", formattingOptions=" + String.valueOf(this.getFormattingOptions()) + ", siteRoot=" + this.getSiteRoot() + ", useDevSite=" + this.isUseDevSite() + ", sendErrors=" + String.valueOf((Object)this.getSendErrors()) + ", traceLog=" + String.valueOf(this.getTraceLog()) + ", configurationRoot=" + String.valueOf(this.getConfigurationRoot()) + ", configurationFile=" + String.valueOf(this.getConfigurationFile()) + ", configurationFilePath=" + this.configurationFilePath + ", globalConfigPath=" + this.globalConfigPath + ")";
    }

    @ConstructorProperties(value={"language", "diagnosticsOptions", "codeLensOptions", "documentLinkOptions", "inlayHintOptions", "formattingOptions", "siteRoot", "useDevSite", "sendErrors", "traceLog", "configurationRoot", "configurationFile", "configurationFilePath", "globalConfigPath"})
    @JsonCreator(mode=JsonCreator.Mode.DISABLED)
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LanguageServerConfiguration(Language language, DiagnosticsOptions diagnosticsOptions, CodeLensOptions codeLensOptions, DocumentLinkOptions documentLinkOptions, InlayHintOptions inlayHintOptions, FormattingOptions formattingOptions, String siteRoot, boolean useDevSite, SendErrorsMode sendErrors, @Nullable File traceLog, @Nullable Path configurationRoot, File configurationFile, @Value(value="${app.configuration.path:.bsl-language-server.json}") String configurationFilePath, @Value(value="${app.globalConfiguration.path:${user.home}/.bsl-language-server.json}") String globalConfigPath) {
        this.language = language;
        this.diagnosticsOptions = diagnosticsOptions;
        this.codeLensOptions = codeLensOptions;
        this.documentLinkOptions = documentLinkOptions;
        this.inlayHintOptions = inlayHintOptions;
        this.formattingOptions = formattingOptions;
        this.siteRoot = siteRoot;
        this.useDevSite = useDevSite;
        this.sendErrors = sendErrors;
        this.traceLog = traceLog;
        this.configurationRoot = configurationRoot;
        this.configurationFile = configurationFile;
        this.configurationFilePath = configurationFilePath;
        this.globalConfigPath = globalConfigPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LanguageServerConfiguration() {
    }

    static {
        LanguageServerConfiguration.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LanguageServerConfiguration.class);
        searchConfiguration = Pattern.compile("Configuration\\.(xml|mdo)$");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LanguageServerConfiguration.java", LanguageServerConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration", "java.io.File", "configurationFile", "", "void"), 144);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reset", "com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration", "", "", "", "void"), 148);
    }
}

