/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.configuration.watcher;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationFileChangeListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFileChangeListener.class);
    private final LanguageServerConfiguration configuration;

    public void onChange(File configurationFile, WatchEvent.Kind<?> eventKind) {
        if (StandardWatchEventKinds.ENTRY_CREATE.equals(eventKind) || StandardWatchEventKinds.ENTRY_MODIFY.equals(eventKind)) {
            this.configuration.update(configurationFile);
            LOGGER.info("BSL Language Server configuration has been reloaded");
        } else if (StandardWatchEventKinds.ENTRY_DELETE.equals(eventKind)) {
            this.configuration.reset();
            LOGGER.info("BSL Language Server configuration has been reset to default");
        } else {
            LOGGER.error("Unknown watch event kind {}", eventKind);
        }
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigurationFileChangeListener(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

