/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context;

import com.github._1c_syntax.bsl.languageserver.WorkDoneProgressHelper;
import com.github._1c_syntax.bsl.languageserver.aop.EventPublisherAspect;
import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.NamedForkJoinWorkerThreadFactory;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdclasses.MDClasses;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.Absolute;
import com.github._1c_syntax.utils.Lazy;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

@Component
public class ServerContext {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private final ObjectProvider<DocumentContext> documentContextProvider;
    private final WorkDoneProgressHelper workDoneProgressHelper;
    private final LanguageServerConfiguration languageServerConfiguration;
    private final Map<URI, DocumentContext> documents = Collections.synchronizedMap(new HashMap());
    private final Lazy<CF> configurationMetadata = new Lazy(this::computeConfigurationMetadata);
    @Nullable
    private Path configurationRoot;
    private final Map<URI, String> mdoRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<ModuleType, DocumentContext>> documentsByMDORef = Collections.synchronizedMap(new HashMap());
    private final ReadWriteLock contextLock = new ReentrantReadWriteLock();
    private final Map<DocumentContext, State> states = new ConcurrentHashMap<DocumentContext, State>();
    private final Set<DocumentContext> openedDocuments = ConcurrentHashMap.newKeySet();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void populateContext() {
        if (this.configurationRoot == null) {
            LOGGER.info("Can't populate server context. Configuration root is not defined.");
            return;
        }
        WorkDoneProgressHelper.WorkDoneProgressReporter workDoneProgressReporter = this.workDoneProgressHelper.createProgress(0, "");
        workDoneProgressReporter.beginProgress(this.getMessage("populateFindFiles"));
        LOGGER.debug("Finding files to populate context...");
        List files = (List)FileUtils.listFiles((File)this.configurationRoot.toFile(), (String[])new String[]{"bsl", "os"}, (boolean)true);
        workDoneProgressReporter.endProgress("");
        this.populateContext(files);
    }

    public void populateContext(List<File> files) {
        List<File> list = files;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        MeasuresAspect.aspectOf().initializeConfiguration(joinPoint, list);
        WorkDoneProgressHelper.WorkDoneProgressReporter workDoneProgressReporter = this.workDoneProgressHelper.createProgress(files.size(), this.getMessage("populateFilesPostfix"));
        workDoneProgressReporter.beginProgress(this.getMessage("populatePopulatingContext"));
        LOGGER.debug("Populating context...");
        this.contextLock.writeLock().lock();
        try {
            files.parallelStream().forEach(file -> {
                workDoneProgressReporter.tick();
                URI uri = file.toURI();
                DocumentContext documentContext = this.getDocument(uri);
                if (documentContext == null) {
                    documentContext = this.createDocumentContext(uri);
                    this.rebuildDocument(documentContext);
                    documentContext.freezeComputedData();
                    this.tryClearDocument(documentContext);
                }
            });
        }
        finally {
            this.contextLock.writeLock().unlock();
        }
        workDoneProgressReporter.endProgress(this.getMessage("populateContextPopulated"));
        LOGGER.debug("Context populated.");
        EventPublisherAspect.aspectOf().serverContextPopulated(joinPoint, list);
    }

    public Map<URI, DocumentContext> getDocuments() {
        return Collections.unmodifiableMap(this.documents);
    }

    @Nullable
    public DocumentContext getDocument(String uri) {
        return this.getDocument(URI.create(uri));
    }

    public Optional<DocumentContext> getDocument(String mdoRef, ModuleType moduleType) {
        Map<ModuleType, DocumentContext> documentsGroup = this.documentsByMDORef.get(mdoRef);
        if (documentsGroup != null) {
            return Optional.ofNullable(documentsGroup.get(moduleType));
        }
        return Optional.empty();
    }

    @Nullable
    public DocumentContext getDocument(URI uri) {
        return this.documents.get(Absolute.uri((URI)uri));
    }

    public Map<ModuleType, DocumentContext> getDocuments(String mdoRef) {
        return this.documentsByMDORef.getOrDefault(mdoRef, Collections.emptyMap());
    }

    public DocumentContext addDocument(URI uri) {
        this.contextLock.readLock().lock();
        DocumentContext documentContext = this.getDocument(uri);
        if (documentContext == null) {
            documentContext = this.createDocumentContext(uri);
        }
        this.contextLock.readLock().unlock();
        return documentContext;
    }

    public void removeDocument(URI uri) {
        URI absoluteURI = Absolute.uri((URI)uri);
        DocumentContext documentContext = this.documents.get(absoluteURI);
        if (this.openedDocuments.contains(documentContext)) {
            throw new IllegalStateException(String.format("Document %s is opened", absoluteURI));
        }
        this.removeDocumentMdoRefByUri(absoluteURI);
        this.states.remove(documentContext);
        this.documents.remove(absoluteURI);
    }

    public void clear() {
        this.documents.clear();
        this.openedDocuments.clear();
        this.states.clear();
        this.documentsByMDORef.clear();
        this.mdoRefs.clear();
        this.configurationMetadata.clear();
    }

    public void openDocument(DocumentContext documentContext, String content, Integer version) {
        this.openedDocuments.add(documentContext);
        documentContext.unfreezeComputedData();
        this.rebuildDocument(documentContext, content, version);
    }

    public void rebuildDocument(DocumentContext documentContext) {
        if (this.states.get(documentContext) == State.WITH_CONTENT) {
            return;
        }
        documentContext.rebuild();
        this.states.put(documentContext, State.WITH_CONTENT);
    }

    public void rebuildDocument(DocumentContext documentContext, String content, Integer version) {
        documentContext.rebuild(content, version);
        this.states.put(documentContext, State.WITH_CONTENT);
    }

    public void tryClearDocument(DocumentContext documentContext) {
        if (this.openedDocuments.contains(documentContext)) {
            return;
        }
        this.states.put(documentContext, State.WITHOUT_CONTENT);
        documentContext.clearSecondaryData();
    }

    public void closeDocument(DocumentContext documentContext) {
        this.openedDocuments.remove(documentContext);
        this.states.put(documentContext, State.WITHOUT_CONTENT);
        documentContext.clearSecondaryData();
    }

    public CF getConfiguration() {
        return (CF)this.configurationMetadata.getOrCompute();
    }

    private DocumentContext createDocumentContext(URI uri) {
        URI absoluteURI = Absolute.uri((URI)uri);
        DocumentContext documentContext = (DocumentContext)this.documentContextProvider.getObject(new Object[]{absoluteURI});
        this.documents.put(absoluteURI, documentContext);
        this.addMdoRefByUri(absoluteURI, documentContext);
        return documentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CF computeConfigurationMetadata() {
        CF configuration;
        if (this.configurationRoot == null) {
            return (CF)MDClasses.createConfiguration();
        }
        WorkDoneProgressHelper.WorkDoneProgressReporter progress = this.workDoneProgressHelper.createProgress(0, "");
        progress.beginProgress(this.getMessage("computeConfigurationMetadata"));
        NamedForkJoinWorkerThreadFactory factory = new NamedForkJoinWorkerThreadFactory("compute-configuration-");
        ForkJoinPool executorService = new ForkJoinPool(ForkJoinPool.getCommonPoolParallelism(), factory, null, true);
        try {
            configuration = (CF)((ForkJoinTask)executorService.submit(() -> MDClasses.createConfiguration((Path)this.configurationRoot))).get();
        }
        catch (ExecutionException e) {
            LOGGER.error("Can't parse configuration metadata. Execution exception.", (Throwable)e);
            configuration = (CF)MDClasses.createConfiguration();
        }
        catch (InterruptedException e) {
            LOGGER.error("Can't parse configuration metadata. Interrupted exception.", (Throwable)e);
            configuration = (CF)MDClasses.createConfiguration();
            Thread.currentThread().interrupt();
        }
        finally {
            executorService.shutdown();
        }
        progress.endProgress(this.getMessage("computeConfigurationMetadataDone"));
        return configuration;
    }

    private void addMdoRefByUri(URI uri, DocumentContext documentContext) {
        String mdoRef = MdoRefBuilder.getMdoRef(documentContext);
        this.mdoRefs.put(uri, mdoRef);
        this.documentsByMDORef.computeIfAbsent(mdoRef, k -> new EnumMap(ModuleType.class)).put(documentContext.getModuleType(), documentContext);
    }

    private void removeDocumentMdoRefByUri(URI uri) {
        String mdoRef = this.mdoRefs.get(uri);
        if (mdoRef != null) {
            Map<ModuleType, DocumentContext> documentsGroup = this.documentsByMDORef.get(mdoRef);
            if (documentsGroup != null) {
                documentsGroup.remove(this.documents.get(uri).getModuleType());
                if (documentsGroup.isEmpty()) {
                    this.documentsByMDORef.remove(mdoRef);
                }
            }
            this.mdoRefs.remove(uri);
        }
    }

    private String getMessage(String key) {
        return Resources.getResourceString(this.languageServerConfiguration.getLanguage(), this.getClass(), key);
    }

    @ConstructorProperties(value={"documentContextProvider", "workDoneProgressHelper", "languageServerConfiguration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServerContext(ObjectProvider<DocumentContext> documentContextProvider, WorkDoneProgressHelper workDoneProgressHelper, LanguageServerConfiguration languageServerConfiguration) {
        this.documentContextProvider = documentContextProvider;
        this.workDoneProgressHelper = workDoneProgressHelper;
        this.languageServerConfiguration = languageServerConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationRoot(@Nullable Path configurationRoot) {
        this.configurationRoot = configurationRoot;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getConfigurationRoot() {
        return this.configurationRoot;
    }

    static {
        ServerContext.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ServerContext.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServerContext.java", ServerContext.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "populateContext", "com.github._1c_syntax.bsl.languageserver.context.ServerContext", "java.util.List", "files", "", "void"), 101);
    }

    private static enum State {
        WITHOUT_CONTENT,
        WITH_CONTENT;

    }
}

