/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.IntBasedVariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ShortBasedVariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTreeVisitor;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableKind;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public abstract class AbstractVariableSymbol
implements VariableSymbol {
    private final String name;
    private final SourceDefinedSymbol scope;
    private final DocumentContext owner;
    private Optional<SourceDefinedSymbol> parent;
    private final byte kind;
    private final boolean export;
    private final Optional<VariableDescription> description;

    @Override
    public List<SourceDefinedSymbol> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.Variable;
    }

    @Override
    public VariableKind getKind() {
        return VariableKind.values()[this.kind];
    }

    @Override
    public abstract Range getVariableNameRange();

    @Override
    public void accept(SymbolTreeVisitor visitor) {
        visitor.visitVariable(this);
    }

    @Override
    public Range getSelectionRange() {
        return this.getVariableNameRange();
    }

    @ConstructorProperties(value={"name", "scope", "owner", "parent", "kind", "export", "description"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    AbstractVariableSymbol(String name, SourceDefinedSymbol scope, DocumentContext owner, Optional<SourceDefinedSymbol> parent, byte kind, boolean export, Optional<VariableDescription> description) {
        this.name = name;
        this.scope = scope;
        this.owner = owner;
        this.parent = parent;
        this.kind = kind;
        this.export = export;
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SourceDefinedSymbol getScope() {
        return this.scope;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContext getOwner() {
        return this.owner;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isExport() {
        return this.export;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<VariableDescription> getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractVariableSymbol)) {
            return false;
        }
        AbstractVariableSymbol other = (AbstractVariableSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DocumentContext this$owner = this.getOwner();
        DocumentContext other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Range this$$getVariableNameRange = this.getVariableNameRange();
        Range other$$getVariableNameRange = other.getVariableNameRange();
        return !(this$$getVariableNameRange == null ? other$$getVariableNameRange != null : !this$$getVariableNameRange.equals(other$$getVariableNameRange));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractVariableSymbol;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DocumentContext $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Range $$getVariableNameRange = this.getVariableNameRange();
        result = result * 59 + ($$getVariableNameRange == null ? 43 : $$getVariableNameRange.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AbstractVariableSymbol(name=" + this.getName() + ", scope=" + String.valueOf(this.getScope()) + ", owner=" + String.valueOf(this.getOwner()) + ", kind=" + String.valueOf((Object)this.getKind()) + ", export=" + this.isExport() + ", description=" + String.valueOf(this.getDescription()) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<SourceDefinedSymbol> getParent() {
        return this.parent;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setParent(Optional<SourceDefinedSymbol> parent) {
        this.parent = parent;
    }

    public static class Builder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SourceDefinedSymbol scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DocumentContext owner;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean export;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<VariableDescription> description;
        private VariableKind kind;
        Optional<SourceDefinedSymbol> parent = Optional.empty();
        private int startLine;
        private int startCharacter;
        private int endLine;
        private int endCharacter;
        private int variableNameLine;
        private int variableNameStartCharacter;
        private int variableNameEndCharacter;

        public Builder range(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.startLine = start.getLine();
            this.startCharacter = start.getCharacter();
            this.endLine = end.getLine();
            this.endCharacter = end.getCharacter();
            return this;
        }

        public Builder variableNameRange(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.variableNameLine = start.getLine();
            this.variableNameStartCharacter = start.getCharacter();
            this.variableNameEndCharacter = end.getCharacter();
            return this;
        }

        public VariableSymbol build() {
            boolean shortBased;
            boolean bl = shortBased = this.startLine <= Short.MAX_VALUE && this.endLine <= Short.MAX_VALUE && this.startCharacter <= Short.MAX_VALUE && this.endCharacter <= Short.MAX_VALUE && this.variableNameLine <= Short.MAX_VALUE && this.variableNameStartCharacter <= Short.MAX_VALUE && this.variableNameEndCharacter <= Short.MAX_VALUE;
            if (shortBased) {
                return new ShortBasedVariableSymbol(this.name, this.scope, this.owner, this.parent, (byte)this.kind.ordinal(), this.export, this.description, (short)this.startLine, (short)this.startCharacter, (short)this.endLine, (short)this.endCharacter, (short)this.variableNameLine, (short)this.variableNameStartCharacter, (short)this.variableNameEndCharacter);
            }
            return new IntBasedVariableSymbol(this.name, this.scope, this.owner, this.parent, (byte)this.kind.ordinal(), this.export, this.description, this.startLine, this.startCharacter, this.endLine, this.endCharacter, this.variableNameLine, this.variableNameStartCharacter, this.variableNameEndCharacter);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Builder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder scope(SourceDefinedSymbol scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder owner(DocumentContext owner) {
            this.owner = owner;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder parent(Optional<SourceDefinedSymbol> parent) {
            this.parent = parent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder kind(VariableKind kind) {
            this.kind = kind;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder export(boolean export) {
            this.export = export;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder description(Optional<VariableDescription> description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbstractVariableSymbol.Builder(name=" + this.name + ", scope=" + String.valueOf(this.scope) + ", owner=" + String.valueOf(this.owner) + ", parent=" + String.valueOf(this.parent) + ", kind=" + String.valueOf((Object)this.kind) + ", export=" + this.export + ", description=" + String.valueOf(this.description) + ")";
        }
    }
}

