/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class ParameterDefinition {
    private final String name;
    private final boolean byValue;
    private final Optional<ParameterDescription> description;
    private final DefaultValue defaultValue;
    private final List<Annotation> annotations;
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;

    public Range getRange() {
        return Ranges.create(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
    }

    public boolean isOptional() {
        return !DefaultValue.EMPTY.equals(this.defaultValue);
    }

    public static ParameterDefinitionBuilder builder() {
        return new ParameterDefinitionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<Annotation> $default$annotations() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"name", "byValue", "description", "defaultValue", "annotations", "startLine", "startCharacter", "endLine", "endCharacter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ParameterDefinition(String name, boolean byValue, Optional<ParameterDescription> description, DefaultValue defaultValue, List<Annotation> annotations, int startLine, int startCharacter, int endLine, int endCharacter) {
        this.name = name;
        this.byValue = byValue;
        this.description = description;
        this.defaultValue = defaultValue;
        this.annotations = annotations;
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isByValue() {
        return this.byValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<ParameterDescription> getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)o;
        if (this.isByValue() != other.isByValue()) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        if (this.startCharacter != other.startCharacter) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endCharacter != other.endCharacter) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<ParameterDescription> this$description = this.getDescription();
        Optional<ParameterDescription> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        DefaultValue this$defaultValue = this.getDefaultValue();
        DefaultValue other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isByValue() ? 79 : 97);
        result = result * 59 + this.startLine;
        result = result * 59 + this.startCharacter;
        result = result * 59 + this.endLine;
        result = result * 59 + this.endCharacter;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<ParameterDescription> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        DefaultValue $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ParameterDefinition(name=" + this.getName() + ", byValue=" + this.isByValue() + ", description=" + String.valueOf(this.getDescription()) + ", defaultValue=" + String.valueOf(this.getDefaultValue()) + ", annotations=" + String.valueOf(this.getAnnotations()) + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")";
    }

    public record DefaultValue(ParameterType type, String value) {
        public static final DefaultValue EMPTY = new DefaultValue(ParameterType.EMPTY, "");
    }

    public static class ParameterDefinitionBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean byValue;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<ParameterDescription> description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DefaultValue defaultValue;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean annotations$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Annotation> annotations$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int startCharacter;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endLine;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int endCharacter;

        public ParameterDefinitionBuilder range(Range range) {
            Position start = range.getStart();
            Position end = range.getEnd();
            this.startLine = start.getLine();
            this.startCharacter = start.getCharacter();
            this.endLine = end.getLine();
            this.endCharacter = end.getCharacter();
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ParameterDefinitionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder byValue(boolean byValue) {
            this.byValue = byValue;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder description(Optional<ParameterDescription> description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder annotations(List<Annotation> annotations) {
            this.annotations$value = annotations;
            this.annotations$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder startCharacter(int startCharacter) {
            this.startCharacter = startCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinitionBuilder endCharacter(int endCharacter) {
            this.endCharacter = endCharacter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ParameterDefinition build() {
            List<Annotation> annotations$value = this.annotations$value;
            if (!this.annotations$set) {
                annotations$value = ParameterDefinition.$default$annotations();
            }
            return new ParameterDefinition(this.name, this.byValue, this.description, this.defaultValue, annotations$value, this.startLine, this.startCharacter, this.endLine, this.endCharacter);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ParameterDefinition.ParameterDefinitionBuilder(name=" + this.name + ", byValue=" + this.byValue + ", description=" + String.valueOf(this.description) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", annotations$value=" + String.valueOf(this.annotations$value) + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")";
        }
    }

    public static enum ParameterType {
        DATETIME,
        BOOLEAN,
        UNDEFINED,
        NULL,
        STRING,
        NUMERIC,
        EMPTY;

    }
}

