/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, scope=DiagnosticScope.BSL, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_12, minutesToFix=1, tags={DiagnosticTag.DEPRECATED})
public class DeprecatedAttributes8312Diagnostic
extends AbstractVisitorDiagnostic {
    private static final String CHART_PLOT_AREA_RU = "\u041e\u0431\u043b\u0430\u0441\u0442\u044c\u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b";
    private static final String CHART_PLOT_AREA_EN = "ChartPlotArea";
    private static final String SHOW_SCALE_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0428\u043a\u0430\u043b\u0443";
    private static final String SHOW_SCALE_EN = "ShowScale";
    private static final String SCALE_LINES_RU = "\u041b\u0438\u043d\u0438\u0438\u0428\u043a\u0430\u043b\u044b";
    private static final String SCALE_COLOR_RU = "\u0426\u0432\u0435\u0442\u0428\u043a\u0430\u043b\u044b";
    private static final String SHOW_SERIES_SCALE_LABELS_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u041f\u043e\u0434\u043f\u0438\u0441\u0438\u0428\u043a\u0430\u043b\u044b\u0421\u0435\u0440\u0438\u0439";
    private static final String SHOW_SERIES_SCALE_LABELS_EN = "ShowSeriesScaleLabels";
    private static final String SHOW_POINTS_SCALE_LABELS_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u041f\u043e\u0434\u043f\u0438\u0441\u0438\u0428\u043a\u0430\u043b\u044b\u0422\u043e\u0447\u0435\u043a";
    private static final String SHOW_POINTS_SCALE_LABELS_EN = "ShowPointsScaleLabels";
    private static final String SHOW_VALUES_SCALE_LABELS_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u041f\u043e\u0434\u043f\u0438\u0441\u0438\u0428\u043a\u0430\u043b\u044b\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439";
    private static final String SHOW_VALUES_SCALE_LABELS_EN = "ShowValuesScaleLabels";
    private static final String SHOW_SCALE_VALUE_LINES_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u041b\u0438\u043d\u0438\u0438\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439\u0428\u043a\u0430\u043b\u044b";
    private static final String SHOW_SCALE_VALUE_LINES_EN = "ShowScaleValueLines";
    private static final String VALUE_SCALE_FORMAT_RU = "\u0424\u043e\u0440\u043c\u0430\u0442\u0428\u043a\u0430\u043b\u044b\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439";
    private static final String VALUE_SCALE_FORMAT_EN = "ValueScaleFormat";
    private static final String LABELS_ORIENTATION_RU = "\u041e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f\u041c\u0435\u0442\u043e\u043a";
    private static final String LABELS_ORIENTATION_EN = "LabelsOrientation";
    private static final String CHART_RU = "\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430";
    private static final String CHART_EN = "Chart";
    private static final String GANTT_CHART_EN = "GanttChart";
    private static final String GANTT_CHART_RU = "\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430\u0413\u0430\u043d\u0442\u0430";
    private static final String PIVOT_CHART_EN = "PivotChart";
    private static final String PIVOT_CHART_RU = "\u0421\u0432\u043e\u0434\u043d\u0430\u044f\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430";
    private static final String SHOW_LEGEND_EN = "ShowLegend";
    private static final String SHOW_LEGEND_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u041b\u0435\u0433\u0435\u043d\u0434\u0443";
    private static final String SHOW_TITLE_EN = "ShowTitle";
    private static final String SHOW_TITLE_RU = "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a";
    private static final String COLOR_PALETTE_EN = "ColorPalette";
    private static final String COLOR_PALETTE_RU = "\u041f\u0430\u043b\u0438\u0442\u0440\u0430\u0426\u0432\u0435\u0442\u043e\u0432";
    private static final String GRADIENT_PALETTE_START_COLOR_EN = "GradientPaletteStartColor";
    private static final String GRADIENT_PALETTE_START_COLOR_RU = "\u0426\u0432\u0435\u0442\u041d\u0430\u0447\u0430\u043b\u0430\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b";
    private static final String GRADIENT_PALETTE_END_COLOR_EN = "GradientPaletteEndColor";
    private static final String GRADIENT_PALETTE_END_COLOR_RU = "\u0426\u0432\u0435\u0442\u041a\u043e\u043d\u0446\u0430\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b";
    private static final String GRADIENT_PALETTE_MAX_COLORS_EN = "GradientPaletteMaxColors";
    private static final String GRADIENT_PALETTE_MAX_COLORS_RU = "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u0426\u0432\u0435\u0442\u043e\u0432\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b";
    private static final String GET_PALETTE_EN = "GetPalette";
    private static final String GET_PALETTE_RU = "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u041f\u0430\u043b\u0438\u0442\u0440\u0443";
    private static final String SET_PALETTE_EN = "SetPalette";
    private static final String SET_PALETTE_RU = "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u041f\u0430\u043b\u0438\u0442\u0440\u0443";
    private static final String CHART_LABELS_ORIENTATION_RU = "\u041e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f\u041c\u0435\u0442\u043e\u043a\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b";
    private static final String CHILD_FORM_ITEMS_GROUP_EN = "ChildFormItemsGroup";
    private static final String CHILD_FORM_ITEMS_GROUP_RU = "\u0413\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u0430\u041f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u044b\u0445\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0424\u043e\u0440\u043c\u044b";
    private static final String CHILD_FORM_ITEMS_GROUP_HORIZONTAL_EN = "Horizontal";
    private static final String CHILD_FORM_ITEMS_GROUP_HORIZONTAL_RU = "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f";
    private static final String CLEAR_EVENT_LOG_EN = "ClearEventLog";
    private static final String CLEAR_EVENT_LOG_RU = "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438";
    private static final HashMap<String, String> NEW_ATTRIBUTES_AND_METHODS = new HashMap();
    private static final Pattern CHART_PLOT_AREA_ATTRIBUTES_PATTERN;
    private static final Pattern CHART_ATTRIBUTES_PATTERN;
    private static final Pattern CHART_METHODS_PATTERN;
    private static final Pattern CHART_PLOT_AREA_NAME_PATTERN;
    private static final Pattern CHART_NAME_PATTERN;
    private static final Pattern CHART_LABELS_ORIENTATION_PATTERN;
    private static final Pattern CHILD_FORM_ITEMS_GROUP_NAME_PATTERN;
    private static final Pattern CHILD_FORM_ITEMS_GROUP_ATTRIBUTE_PATTERN;
    private static final Pattern CLEAR_EVENT_LOG_PATTERN;

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        Matcher matcher = CHART_METHODS_PATTERN.matcher(ctx.methodName().getText());
        if (matcher.matches()) {
            String deprecatedMethod = matcher.group();
            String message = this.info.getResourceString("deprecatedMethodsMessage", deprecatedMethod, Objects.requireNonNullElse(NEW_ATTRIBUTES_AND_METHODS.get(deprecatedMethod.toLowerCase(Locale.ENGLISH)), ""));
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(message));
        }
        return (ParseTree)super.visitMethodCall(ctx);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        Matcher matcher = CLEAR_EVENT_LOG_PATTERN.matcher(ctx.methodName().getText());
        if (matcher.matches()) {
            String deprecatedMethod = ctx.getStart().getText();
            String message = this.info.getResourceString("deprecatedGlobalMethodsMessage", deprecatedMethod);
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(message));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitAccessProperty(BSLParser.AccessPropertyContext ctx) {
        HashMap<Pattern, Pattern> patternsToCheck = new HashMap<Pattern, Pattern>();
        patternsToCheck.put(CHART_PLOT_AREA_NAME_PATTERN, CHART_PLOT_AREA_ATTRIBUTES_PATTERN);
        patternsToCheck.put(CHART_NAME_PATTERN, CHART_ATTRIBUTES_PATTERN);
        patternsToCheck.put(CHILD_FORM_ITEMS_GROUP_NAME_PATTERN, CHILD_FORM_ITEMS_GROUP_ATTRIBUTE_PATTERN);
        patternsToCheck.forEach((k, v) -> this.checkDeprecatedAttributes((BSLParserRuleContext)ctx, (Pattern)k, (Pattern)v));
        return (ParseTree)super.visitAccessProperty(ctx);
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        Matcher matcher = CHART_LABELS_ORIENTATION_PATTERN.matcher(ctx.getStart().getText());
        if (matcher.matches()) {
            String deprecatedEnum = ctx.getStart().getText();
            String message = this.info.getResourceString("deprecatedEnumNameMessage", deprecatedEnum, Objects.requireNonNullElse(NEW_ATTRIBUTES_AND_METHODS.get(deprecatedEnum.toLowerCase(Locale.ENGLISH)), ""));
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(message));
        }
        return (ParseTree)super.visitComplexIdentifier(ctx);
    }

    private void checkDeprecatedAttributes(BSLParserRuleContext ctx, Pattern objectNamePattern, Pattern deprecatedAttributesPattern) {
        Matcher deprecatedAttributesMatcher = deprecatedAttributesPattern.matcher(ctx.getText().substring(1));
        if (deprecatedAttributesMatcher.matches()) {
            BSLParserRuleContext complexCtx = Trees.getAncestorByRuleIndex(ctx, 95);
            if (complexCtx == null && (complexCtx = Trees.getAncestorByRuleIndex(ctx, 98)) == null) {
                return;
            }
            if (objectNamePattern.matcher(complexCtx.getStart().getText()).matches()) {
                String deprecatedAttribute = deprecatedAttributesMatcher.group();
                String message = this.info.getResourceString("deprecatedAttributeMessage", deprecatedAttribute, Objects.requireNonNullElse(NEW_ATTRIBUTES_AND_METHODS.get(deprecatedAttribute.toLowerCase(Locale.ENGLISH)), ""));
                this.diagnosticStorage.addDiagnostic(ctx, this.info.getMessage(message));
            }
        }
    }

    private static String getDeprecatedAttributesRegex(Metaobject metaobject) {
        HashMap<String, String> attributesPair = new HashMap<String, String>();
        if (metaobject == Metaobject.CHART_PLOT_AREA) {
            attributesPair.put(SHOW_SCALE_RU, SHOW_SCALE_EN);
            attributesPair.put(SCALE_LINES_RU, "");
            attributesPair.put(SCALE_COLOR_RU, "");
            attributesPair.put(SHOW_SERIES_SCALE_LABELS_RU, SHOW_SERIES_SCALE_LABELS_EN);
            attributesPair.put(SHOW_POINTS_SCALE_LABELS_RU, SHOW_POINTS_SCALE_LABELS_EN);
            attributesPair.put(SHOW_VALUES_SCALE_LABELS_RU, SHOW_VALUES_SCALE_LABELS_EN);
            attributesPair.put(SHOW_SCALE_VALUE_LINES_RU, SHOW_SCALE_VALUE_LINES_EN);
            attributesPair.put(VALUE_SCALE_FORMAT_RU, VALUE_SCALE_FORMAT_EN);
            attributesPair.put(LABELS_ORIENTATION_RU, LABELS_ORIENTATION_EN);
        } else if (metaobject == Metaobject.CHART) {
            attributesPair.put(SHOW_LEGEND_EN, SHOW_LEGEND_RU);
            attributesPair.put(SHOW_TITLE_EN, SHOW_TITLE_RU);
            attributesPair.put(COLOR_PALETTE_EN, COLOR_PALETTE_RU);
            attributesPair.put(GRADIENT_PALETTE_START_COLOR_EN, GRADIENT_PALETTE_START_COLOR_RU);
            attributesPair.put(GRADIENT_PALETTE_END_COLOR_EN, GRADIENT_PALETTE_END_COLOR_RU);
            attributesPair.put(GRADIENT_PALETTE_MAX_COLORS_EN, GRADIENT_PALETTE_MAX_COLORS_RU);
        } else if (metaobject == Metaobject.ENUM_ITEMS_GROUP) {
            attributesPair.put(CHILD_FORM_ITEMS_GROUP_HORIZONTAL_EN, CHILD_FORM_ITEMS_GROUP_HORIZONTAL_RU);
        }
        StringJoiner regex = new StringJoiner("|");
        attributesPair.forEach((k, v) -> {
            regex.add((CharSequence)k);
            regex.add((CharSequence)v);
        });
        return regex.toString();
    }

    private static String getDeprecatedMethodsRegex(Metaobject metaobject) {
        HashMap<String, String> attributesPair = new HashMap<String, String>();
        if (metaobject == Metaobject.CHART) {
            attributesPair.put(GET_PALETTE_EN, GET_PALETTE_RU);
            attributesPair.put(SET_PALETTE_EN, SET_PALETTE_RU);
        }
        StringJoiner regex = new StringJoiner("|");
        attributesPair.forEach((k, v) -> {
            regex.add((CharSequence)k);
            regex.add((CharSequence)v);
        });
        return regex.toString();
    }

    private static String getMetaobjectNameRegex(Metaobject metaobject) {
        HashMap<String, String> namePair = new HashMap<String, String>();
        if (metaobject == Metaobject.CHART_PLOT_AREA) {
            namePair.put(CHART_PLOT_AREA_RU, CHART_PLOT_AREA_EN);
        } else if (metaobject == Metaobject.CHART) {
            namePair.put(CHART_RU, CHART_EN);
            namePair.put(GANTT_CHART_EN, GANTT_CHART_RU);
            namePair.put(PIVOT_CHART_EN, PIVOT_CHART_RU);
        } else if (metaobject == Metaobject.ENUM_ITEMS_GROUP) {
            namePair.put(CHILD_FORM_ITEMS_GROUP_EN, CHILD_FORM_ITEMS_GROUP_RU);
        }
        StringJoiner regex = new StringJoiner("|");
        namePair.forEach((k, v) -> {
            regex.add((CharSequence)k);
            regex.add((CharSequence)v);
        });
        return regex.toString();
    }

    static {
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SCALE_RU.toLowerCase(Locale.ENGLISH), "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0428\u043a\u0430\u043b\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SCALE_EN.toLowerCase(Locale.ENGLISH), "ShowScales");
        NEW_ATTRIBUTES_AND_METHODS.put(SCALE_LINES_RU.toLowerCase(Locale.ENGLISH), "\u041b\u0438\u043d\u0438\u0438\u0428\u043a\u0430\u043b");
        NEW_ATTRIBUTES_AND_METHODS.put(SCALE_COLOR_RU.toLowerCase(Locale.ENGLISH), "\u0426\u0432\u0435\u0442\u0428\u043a\u0430\u043b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SERIES_SCALE_LABELS_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0421\u0435\u0440\u0438\u0439.\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439\u0428\u043a\u0430\u043b\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SERIES_SCALE_LABELS_EN.toLowerCase(Locale.ENGLISH), "SeriesScale.ScaleLabelLocation");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_POINTS_SCALE_LABELS_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0422\u043e\u0447\u0435\u043a.\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439\u0428\u043a\u0430\u043b\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_POINTS_SCALE_LABELS_EN.toLowerCase(Locale.ENGLISH), "PointsScale.ScaleLabelLocation");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_VALUES_SCALE_LABELS_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439.\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439\u0428\u043a\u0430\u043b\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_VALUES_SCALE_LABELS_EN.toLowerCase(Locale.ENGLISH), "ValuesScale.ScaleLabelLocation");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SCALE_VALUE_LINES_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439.\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u041b\u0438\u043d\u0438\u0439\u0421\u0435\u0442\u043a\u0438");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_SCALE_VALUE_LINES_EN.toLowerCase(Locale.ENGLISH), "ValuesScale.GridLinesShowMode");
        NEW_ATTRIBUTES_AND_METHODS.put(VALUE_SCALE_FORMAT_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0439.\u0424\u043e\u0440\u043c\u0430\u0442\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439");
        NEW_ATTRIBUTES_AND_METHODS.put(VALUE_SCALE_FORMAT_EN.toLowerCase(Locale.ENGLISH), "ValuesScale.LabelFormat");
        NEW_ATTRIBUTES_AND_METHODS.put(LABELS_ORIENTATION_RU.toLowerCase(Locale.ENGLISH), "\u0428\u043a\u0430\u043b\u0430\u0422\u043e\u0447\u0435\u043a.\u041e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439");
        NEW_ATTRIBUTES_AND_METHODS.put(LABELS_ORIENTATION_EN.toLowerCase(Locale.ENGLISH), "PointsScale.LabelOrientation");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_LEGEND_RU.toLowerCase(Locale.ENGLISH), "\u043e\u0434\u043d\u043e \u0438\u0437 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u041b\u0435\u0433\u0435\u043d\u0434\u044b\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b, \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u041b\u0435\u0433\u0435\u043d\u0434\u044b\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b\u0413\u0430\u043d\u0442\u0430 \u0438\u043b\u0438 \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u041b\u0435\u0433\u0435\u043d\u0434\u044b\u0421\u0432\u043e\u0434\u043d\u043e\u0439\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_LEGEND_EN.toLowerCase(Locale.ENGLISH), "one of the properties of ChartLegendArea, GanttChartLegendArea or PivotChartLegendArea");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_TITLE_EN.toLowerCase(Locale.ENGLISH), "one of the properties of ChartTitleArea, GanttChartTitleArea or PivotChartTitleArea");
        NEW_ATTRIBUTES_AND_METHODS.put(SHOW_TITLE_RU.toLowerCase(Locale.ENGLISH), "\u043e\u0434\u043d\u043e \u0438\u0437 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b, \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b\u0413\u0430\u043d\u0442\u0430 \u0438\u043b\u0438 \u041e\u0431\u043b\u0430\u0441\u0442\u044c\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430\u0421\u0432\u043e\u0434\u043d\u043e\u0439\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(COLOR_PALETTE_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.ColorPalette");
        NEW_ATTRIBUTES_AND_METHODS.put(COLOR_PALETTE_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u041f\u0430\u043b\u0438\u0442\u0440\u0430\u0426\u0432\u0435\u0442\u043e\u0432");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_START_COLOR_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.GradientPaletteStartColor");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_START_COLOR_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u0426\u0432\u0435\u0442\u041d\u0430\u0447\u0430\u043b\u0430\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_END_COLOR_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.GradientPaletteEndColor");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_END_COLOR_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u0426\u0432\u0435\u0442\u041a\u043e\u043d\u0446\u0430\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_MAX_COLORS_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.GradientPaletteMaxColors");
        NEW_ATTRIBUTES_AND_METHODS.put(GRADIENT_PALETTE_MAX_COLORS_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u0426\u0432\u0435\u0442\u043e\u0432\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u043d\u043e\u0439\u041f\u0430\u043b\u0438\u0442\u0440\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(GET_PALETTE_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.GetPalette");
        NEW_ATTRIBUTES_AND_METHODS.put(GET_PALETTE_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c\u041f\u0430\u043b\u0438\u0442\u0440\u0443");
        NEW_ATTRIBUTES_AND_METHODS.put(SET_PALETTE_EN.toLowerCase(Locale.ENGLISH), "ColorPaletteDescription.SetPalette");
        NEW_ATTRIBUTES_AND_METHODS.put(SET_PALETTE_RU.toLowerCase(Locale.ENGLISH), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0430\u043b\u0438\u0442\u0440\u044b\u0426\u0432\u0435\u0442\u043e\u0432.\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u041f\u0430\u043b\u0438\u0442\u0440\u0443");
        NEW_ATTRIBUTES_AND_METHODS.put(CHART_LABELS_ORIENTATION_RU.toLowerCase(Locale.ENGLISH), "\u041e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f\u041f\u043e\u0434\u043f\u0438\u0441\u0435\u0439\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b");
        NEW_ATTRIBUTES_AND_METHODS.put(CHILD_FORM_ITEMS_GROUP_HORIZONTAL_EN.toLowerCase(Locale.ENGLISH), "AlwaysHorizontal");
        NEW_ATTRIBUTES_AND_METHODS.put(CHILD_FORM_ITEMS_GROUP_HORIZONTAL_RU.toLowerCase(Locale.ENGLISH), "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f\u0412\u0441\u0435\u0433\u0434\u0430");
        CHART_PLOT_AREA_ATTRIBUTES_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getDeprecatedAttributesRegex(Metaobject.CHART_PLOT_AREA));
        CHART_ATTRIBUTES_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getDeprecatedAttributesRegex(Metaobject.CHART));
        CHART_METHODS_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getDeprecatedMethodsRegex(Metaobject.CHART));
        CHART_PLOT_AREA_NAME_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getMetaobjectNameRegex(Metaobject.CHART_PLOT_AREA));
        CHART_NAME_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getMetaobjectNameRegex(Metaobject.CHART));
        CHART_LABELS_ORIENTATION_PATTERN = CaseInsensitivePattern.compile((String)CHART_LABELS_ORIENTATION_RU);
        CHILD_FORM_ITEMS_GROUP_NAME_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getMetaobjectNameRegex(Metaobject.ENUM_ITEMS_GROUP));
        CHILD_FORM_ITEMS_GROUP_ATTRIBUTE_PATTERN = CaseInsensitivePattern.compile((String)DeprecatedAttributes8312Diagnostic.getDeprecatedAttributesRegex(Metaobject.ENUM_ITEMS_GROUP));
        CLEAR_EVENT_LOG_PATTERN = CaseInsensitivePattern.compile((String)"ClearEventLog|\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
    }

    private static enum Metaobject {
        CHART,
        CHART_PLOT_AREA,
        ENUM_ITEMS_GROUP;

    }
}

