/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Optional;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.VULNERABILITY, severity=DiagnosticSeverity.MAJOR, minutesToFix=15, tags={DiagnosticTag.SUSPICIOUS}, scope=DiagnosticScope.BSL)
public class DisableSafeModeDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern methodPattern = CaseInsensitivePattern.compile((String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0411\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u044b\u0439\u0420\u0435\u0436\u0438\u043c|SetSafeMode|\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u0411\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0433\u043e\u0420\u0435\u0436\u0438\u043c\u0430|SetSafeModeDisabled");
    private static final Pattern safeModePattern = CaseInsensitivePattern.compile((String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0411\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u044b\u0439\u0420\u0435\u0436\u0438\u043c|SetSafeMode");

    public DisableSafeModeDiagnostic() {
        super(methodPattern);
    }

    @Override
    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        boolean result = super.checkGlobalMethodCall(ctx);
        if (!result) {
            return false;
        }
        int enabledValue = safeModePattern.matcher(ctx.methodName().getText()).matches() ? 30 : 31;
        return !DisableSafeModeDiagnostic.enabledCall(ctx, enabledValue);
    }

    private static boolean enabledCall(BSLParser.GlobalMethodCallContext ctx, int enabledValue) {
        return Optional.of(ctx).map(BSLParser.GlobalMethodCallContext::doCall).map(BSLParser.DoCallContext::callParamList).map(BSLParser.CallParamListContext::callParam).filter(callParamContexts -> callParamContexts.size() == 1).map(callParamContexts -> (BSLParser.CallParamContext)callParamContexts.get(0)).map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).map(memberContexts -> (BSLParser.MemberContext)memberContexts.get(0)).map(BSLParser.MemberContext::constValue).filter(constValueContext -> constValueContext.getToken(enabledValue, 0) != null).isPresent();
    }
}

