/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractExpressionTreeDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionNodeType;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import org.antlr.v4.runtime.Token;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=3, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.BADPRACTICE})
public class DoubleNegativesDiagnostic
extends AbstractExpressionTreeDiagnostic {
    @Override
    protected void visitBinaryOperation(BinaryOperationNode node) {
        if (node.getOperator() != BslOperator.EQUAL && node.getOperator() != BslOperator.NOT_EQUAL) {
            super.visitBinaryOperation(node);
            return;
        }
        BslExpression parent = node.getParent();
        if (parent == null || !DoubleNegativesDiagnostic.isNegationOperator(parent)) {
            super.visitBinaryOperation(node);
            return;
        }
        if (node.getOperator() == BslOperator.NOT_EQUAL) {
            this.addDiagnostic(node);
        }
        super.visitBinaryOperation(node);
    }

    @Override
    protected void visitUnaryOperation(UnaryOperationNode node) {
        UnaryOperationNode unaryParent;
        if (node.getOperator() == BslOperator.NOT && node.getParent() != null && node.getParent().getNodeType() == ExpressionNodeType.UNARY_OP && (unaryParent = (UnaryOperationNode)node.getParent().cast()).getOperator() == BslOperator.NOT) {
            this.addDiagnostic(node);
        }
        super.visitUnaryOperation(node);
    }

    private static boolean isNegationOperator(BslExpression parent) {
        return parent.getNodeType() == ExpressionNodeType.UNARY_OP && ((UnaryOperationNode)parent.cast()).getOperator() == BslOperator.NOT;
    }

    private void addDiagnostic(BinaryOperationNode node) {
        Token startToken = (Token)Trees.getTokens(node.getParent().getRepresentingAst()).stream().findFirst().orElseThrow();
        Token endToken = (Token)Trees.getTokens(node.getRight().getRepresentingAst()).stream().reduce((one, two) -> two).orElseThrow();
        this.diagnosticStorage.addDiagnostic(startToken, endToken);
    }

    private void addDiagnostic(UnaryOperationNode node) {
        Token startToken = (Token)Trees.getTokens(node.getParent().getRepresentingAst()).stream().findFirst().orElseThrow();
        Token endToken = (Token)Trees.getTokens(node.getOperand().getRepresentingAst()).stream().reduce((one, two) -> two).orElseThrow();
        this.diagnosticStorage.addDiagnostic(startToken, endToken);
    }
}

