/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD}, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_1)
public class DuplicateRegionDiagnostic
extends AbstractVisitorDiagnostic {
    private final Map<String, String> regionNames = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public DuplicateRegionDiagnostic() {
        this.regionNames.put("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", "Public");
        this.regionNames.put("Public", "Public");
        this.regionNames.put("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", "Internal");
        this.regionNames.put("Internal", "Internal");
        this.regionNames.put("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0435\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b\u0418\u0424\u0443\u043d\u043a\u0446\u0438\u0438", "Private");
        this.regionNames.put("Private", "Private");
        this.regionNames.put("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439", "EventHandlers");
        this.regionNames.put("EventHandlers", "EventHandlers");
        this.regionNames.put("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u0424\u043e\u0440\u043c\u044b", "FormEventHandlers");
        this.regionNames.put("FormEventHandlers", "FormEventHandlers");
        this.regionNames.put("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u0421\u043e\u0431\u044b\u0442\u0438\u0439\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u0428\u0430\u043f\u043a\u0438\u0424\u043e\u0440\u043c\u044b", "FormHeaderItemsEventHandlers");
        this.regionNames.put("FormHeaderItemsEventHandlers", "FormHeaderItemsEventHandlers");
        this.regionNames.put("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438\u041a\u043e\u043c\u0430\u043d\u0434\u0424\u043e\u0440\u043c\u044b", "FormCommandsEventHandlers");
        this.regionNames.put("FormCommandsEventHandlers", "FormCommandsEventHandlers");
        this.regionNames.put("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445", "Variables");
        this.regionNames.put("Variables", "Variables");
        this.regionNames.put("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", "Initialize");
        this.regionNames.put("Initialize", "Initialize");
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        List<RegionSymbol> regions = this.documentContext.getSymbolTree().getModuleLevelRegions();
        if (regions.isEmpty()) {
            return ctx;
        }
        regions.stream().collect(Collectors.groupingBy(regionSymbol -> this.regionNames.getOrDefault(regionSymbol.getName(), regionSymbol.getName()))).forEach((name, regionsList) -> {
            if (regionsList.size() > 1) {
                ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
                RegionSymbol currentRegion = (RegionSymbol)regionsList.get(0);
                Range currentRange = currentRegion.getStartRange();
                regionsList.stream().map(region -> RelatedInformation.create(this.documentContext.getUri(), region.getStartRange(), "+1")).collect(Collectors.toCollection(() -> relatedInformation));
                this.diagnosticStorage.addDiagnostic(currentRange, this.info.getMessage(currentRegion.getName()), relatedInformation);
            }
        });
        return ctx;
    }
}

