/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, activatedByDefault=false, tags={DiagnosticTag.DESIGN})
public class FunctionOutParameterDiagnostic
extends AbstractVisitorDiagnostic {
    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        List<ParameterDefinition> parameters = this.documentContext.getSymbolTree().getMethodSymbol(ctx.getParent()).stream().map(MethodSymbol::getParameters).flatMap(Collection::stream).filter(param -> !param.isByValue()).toList();
        if (parameters.isEmpty()) {
            return ctx;
        }
        CaseInsensitiveMap lvalues = Trees.findAllRuleNodes((ParseTree)ctx.subCodeBlock(), 98).stream().collect(Collectors.toMap(ParseTree::getText, BSLParserRuleContext.class::cast, (existing, replacement) -> existing, CaseInsensitiveMap::new));
        parameters.stream().filter(param -> lvalues.containsKey((Object)param.getName())).map(param -> (BSLParserRuleContext)lvalues.get((Object)param.getName())).filter(Objects::nonNull).forEach(this.diagnosticStorage::addDiagnostic);
        return ctx;
    }
}

