/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractExpressionTreeDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.FormatProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionNodeType;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.NodeEqualityComparer;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TransitiveOperationsIgnoringComparer;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.FormattingOptions;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.SUSPICIOUS})
public class IdenticalExpressionsDiagnostic
extends AbstractExpressionTreeDiagnostic {
    private static final int MIN_EXPRESSION_SIZE = 3;
    private static final String POPULAR_DIVISORS_DEFAULT_VALUE = "60, 1024";
    @DiagnosticParameter(type=String.class, defaultValue="60, 1024")
    private Set<String> popularDivisors = IdenticalExpressionsDiagnostic.parseCommaSeparatedSet("60, 1024");
    private final FormatProvider formatProvider;
    private final List<BinaryOperationNode> binaryOperations = new ArrayList<BinaryOperationNode>();
    private BSLParser.ExpressionContext expressionContext;

    private static Set<String> parseCommaSeparatedSet(String values) {
        if (values.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(values.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        String popularDivisorsValue = (String)configuration.getOrDefault("popularDivisors", POPULAR_DIVISORS_DEFAULT_VALUE);
        this.popularDivisors = IdenticalExpressionsDiagnostic.parseCommaSeparatedSet(popularDivisorsValue);
    }

    @Override
    protected AbstractExpressionTreeDiagnostic.ExpressionVisitorDecision onExpressionEnter(BSLParser.ExpressionContext ctx) {
        this.expressionContext = ctx;
        return IdenticalExpressionsDiagnostic.sufficientSize(ctx) ? AbstractExpressionTreeDiagnostic.ExpressionVisitorDecision.SKIP : AbstractExpressionTreeDiagnostic.ExpressionVisitorDecision.ACCEPT;
    }

    @Override
    protected void visitTopLevelExpression(BslExpression node) {
        this.binaryOperations.clear();
        super.visitTopLevelExpression(node);
        TransitiveOperationsIgnoringComparer comparer = new TransitiveOperationsIgnoringComparer();
        comparer.logicalOperationsAsTransitive(true);
        this.binaryOperations.stream().filter(x -> this.checkEquality(comparer, (BinaryOperationNode)x)).forEach(x -> this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)this.expressionContext, this.info.getMessage(x.getRepresentingAst().getText(), this.getOperandText((BinaryOperationNode)x))));
    }

    @Override
    protected void visitBinaryOperation(BinaryOperationNode node) {
        BslOperator operator = node.getOperator();
        if (operator == BslOperator.DEREFERENCE || operator == BslOperator.INDEX_ACCESS) {
            return;
        }
        if (operator != BslOperator.ADD && operator != BslOperator.MULTIPLY) {
            this.binaryOperations.add(node);
        }
        super.visitBinaryOperation(node);
    }

    private boolean checkEquality(NodeEqualityComparer comparer, BinaryOperationNode node) {
        boolean justEqual = comparer.areEqual(node.getLeft(), node.getRight());
        if (justEqual) {
            return !this.isPopularQuantification(node);
        }
        if (IdenticalExpressionsDiagnostic.isComplementary(node)) {
            BslExpression searchableLeft = node.getLeft();
            BinaryOperationNode complementaryNode = (BinaryOperationNode)node.getRight().cast();
            while (true) {
                boolean equal;
                boolean bl = equal = comparer.areEqual(searchableLeft, complementaryNode.getLeft()) || comparer.areEqual(searchableLeft, complementaryNode.getRight());
                if (equal) {
                    return true;
                }
                if (!IdenticalExpressionsDiagnostic.isComplementary(complementaryNode)) break;
                complementaryNode = (BinaryOperationNode)complementaryNode.getRight().cast();
            }
        }
        return false;
    }

    private boolean isPopularQuantification(BinaryOperationNode node) {
        BSLParser.ConstValueContext leftAst;
        BSLParser.NumericContext number;
        if (this.popularDivisors.isEmpty()) {
            return false;
        }
        if (node.getOperator() == BslOperator.DIVIDE && node.getLeft().getNodeType() == ExpressionNodeType.LITERAL && (number = (leftAst = (BSLParser.ConstValueContext)node.getLeft().getRepresentingAst()).numeric()) != null) {
            String text = number.getText();
            return this.popularDivisors.contains(text);
        }
        return false;
    }

    private String getOperandText(BinaryOperationNode node) {
        assert (node.getRepresentingAst() != null);
        BslExpression pairedOperand = node.getLeft();
        ArrayList<Token> tokens = new ArrayList<Token>();
        IdenticalExpressionsDiagnostic.fillTokens(pairedOperand, tokens);
        return this.formatProvider.getNewText(tokens, this.documentContext.getScriptVariantLocale(), Ranges.create(), 0, new FormattingOptions()).trim();
    }

    private static List<Token> collectTokensForUnaryOperation(UnaryOperationNode unary, List<Token> tokens) {
        tokens.addAll(Trees.getTokens(unary.getRepresentingAst()));
        IdenticalExpressionsDiagnostic.fillTokens(unary.getOperand(), tokens);
        return tokens;
    }

    private static List<Token> collectTokensForBinaryOperation(BinaryOperationNode binary, List<Token> tokens) {
        IdenticalExpressionsDiagnostic.fillTokens(binary.getLeft(), tokens);
        tokens.addAll(Trees.getTokens(binary.getRepresentingAst()));
        IdenticalExpressionsDiagnostic.fillTokens(binary.getRight(), tokens);
        return tokens;
    }

    private static void fillTokens(BslExpression node, List<Token> collection) {
        if (node instanceof BinaryOperationNode) {
            IdenticalExpressionsDiagnostic.collectTokensForBinaryOperation((BinaryOperationNode)node.cast(), collection);
        } else if (node instanceof UnaryOperationNode) {
            IdenticalExpressionsDiagnostic.collectTokensForUnaryOperation((UnaryOperationNode)node.cast(), collection);
        } else {
            collection.addAll(Trees.getTokens(node.getRepresentingAst()));
        }
    }

    private static boolean isComplementary(BinaryOperationNode binary) {
        BslOperator operator = binary.getOperator();
        if ((operator == BslOperator.OR || operator == BslOperator.AND) && binary.getRight() instanceof BinaryOperationNode) {
            return ((BinaryOperationNode)binary.getRight()).getOperator() == operator;
        }
        return false;
    }

    private static boolean sufficientSize(BSLParser.ExpressionContext ctx) {
        return ctx.children.size() < 3;
    }

    @ConstructorProperties(value={"formatProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IdenticalExpressionsDiagnostic(FormatProvider formatProvider) {
        this.formatProvider = formatProvider;
    }
}

