/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.TerminalNode;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=1, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.SUSPICIOUS, DiagnosticTag.UNPREDICTABLE})
public class IncorrectUseOfStrTemplateDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern messagePattern = CaseInsensitivePattern.compile((String)"(\u0441\u0442\u0440\u0448\u0430\u0431\u043b\u043e\u043d|strtemplate)");
    private static final Pattern paramsPattern = Pattern.compile("(?<!%)%(?:(10|[1-9])(?!\\d)|\\((10|[1-9])\\))");
    private static final Pattern wrongNumbersPattern = Pattern.compile("(?<!%)%(?:(1[1-9]\\d*|[2-9]\\d+|0|10\\d+)(?!\\d)|\\((1[1-9]\\d*|[2-9]\\d+|0|10\\d+)\\))");
    private static final Pattern TWO_PERCENT_PATTERN = Pattern.compile("%%");
    private static final Pattern nstrPattern = CaseInsensitivePattern.compile((String)"(\u043d\u0441\u0442\u0440|nstr)");

    public IncorrectUseOfStrTemplateDiagnostic() {
        super(messagePattern);
    }

    private static boolean paramsAreDifferent(BSLParser.GlobalMethodCallContext ctx) {
        List params = ctx.doCall().callParamList().callParam();
        if (params.isEmpty()) {
            return false;
        }
        String templateString = IncorrectUseOfStrTemplateDiagnostic.getTemplateString((BSLParser.CallParamContext)params.get(0));
        if (templateString == null) {
            return false;
        }
        int usedParamsCount = params.size() - 1;
        return IncorrectUseOfStrTemplateDiagnostic.isWrongTemplate(templateString, usedParamsCount);
    }

    private static boolean isWrongTemplate(String templateString, int usedParamsCount) {
        boolean isWrongCall = IncorrectUseOfStrTemplateDiagnostic.compareTemplateAndParams(templateString, usedParamsCount);
        if (!isWrongCall) {
            return false;
        }
        String str = TWO_PERCENT_PATTERN.matcher(templateString).replaceAll("");
        return IncorrectUseOfStrTemplateDiagnostic.compareTemplateAndParams(str, usedParamsCount);
    }

    private static boolean compareTemplateAndParams(String templateString, int usedParamsCount) {
        boolean haveParams = usedParamsCount > 0;
        Matcher matcher = paramsPattern.matcher(templateString);
        boolean matches = matcher.find();
        return matches && !haveParams || !matches && haveParams || matches && IncorrectUseOfStrTemplateDiagnostic.variousParams(usedParamsCount, matcher) || wrongNumbersPattern.matcher(templateString).find();
    }

    @Nullable
    private static String getTemplateString(BSLParser.CallParamContext context) {
        Optional<BSLParser.CallParamContext> ctx = Optional.of(context);
        String templateStringBefore = IncorrectUseOfStrTemplateDiagnostic.getString(ctx).orElseGet(() -> IncorrectUseOfStrTemplateDiagnostic.getStringFromNStrCall(ctx).orElse(""));
        if (templateStringBefore.isEmpty()) {
            return null;
        }
        return templateStringBefore.substring(1, templateStringBefore.length() - 1);
    }

    private static Optional<String> getString(Optional<BSLParser.CallParamContext> ctx) {
        Optional<BSLParser.ExpressionContext> expressionContext = ctx.map(BSLParser.CallParamContext::expression);
        return IncorrectUseOfStrTemplateDiagnostic.getStringFromExpression(expressionContext);
    }

    private static Optional<String> getStringFromExpression(Optional<BSLParser.ExpressionContext> expressionContext) {
        int LENGTH_OF_EMPTY_STRING_FROM_AST = 2;
        return IncorrectUseOfStrTemplateDiagnostic.getConstValue(expressionContext, true).map(BSLParser.ConstValueContext::string).map(BSLParserRuleContext::getText).filter(s -> s.length() > 2);
    }

    private static Optional<BSLParser.ConstValueContext> getConstValue(Optional<BSLParser.ExpressionContext> expressionContext, boolean isFullSearch) {
        return expressionContext.map(BSLParser.ExpressionContext::member).filter(memberContexts -> memberContexts.size() == 1).map(memberContexts -> (BSLParser.MemberContext)memberContexts.get(0)).flatMap(memberContext -> IncorrectUseOfStrTemplateDiagnostic.calcStringForMemberContext(memberContext, isFullSearch));
    }

    private static Optional<BSLParser.ConstValueContext> calcStringForMemberContext(BSLParser.MemberContext memberContext, boolean isFullSearch) {
        BSLParser.ComplexIdentifierContext complexIdentifier;
        BSLParser.ConstValueContext constValue = memberContext.constValue();
        if (constValue != null) {
            return Optional.of(constValue);
        }
        if (isFullSearch && (complexIdentifier = memberContext.complexIdentifier()) != null) {
            return IncorrectUseOfStrTemplateDiagnostic.calcAssignedValueForIdentifier(complexIdentifier);
        }
        return Optional.empty();
    }

    private static Optional<BSLParser.ConstValueContext> calcAssignedValueForIdentifier(BSLParser.ComplexIdentifierContext complexIdentifier) {
        TerminalNode identifier = complexIdentifier.IDENTIFIER();
        if (identifier == null) {
            return Optional.empty();
        }
        String varName = identifier.getText();
        BSLParser.StatementContext prevStatement = (BSLParser.StatementContext)Objects.requireNonNull(Trees.getRootParent((BSLParserRuleContext)complexIdentifier, 80));
        while ((prevStatement = (BSLParser.StatementContext)IncorrectUseOfStrTemplateDiagnostic.getPreviousNode((BSLParserRuleContext)Objects.requireNonNull(prevStatement), 80)) != null) {
            Optional<BSLParser.ConstValueContext> constValueContext = Optional.ofNullable(prevStatement.assignment()).filter(assignment -> IncorrectUseOfStrTemplateDiagnostic.isAssignmentForVar(varName, assignment)).map(BSLParser.AssignmentContext::expression).flatMap(expression -> IncorrectUseOfStrTemplateDiagnostic.getConstValue(Optional.of(expression), false));
            if (!constValueContext.isPresent()) continue;
            return constValueContext;
        }
        return Optional.empty();
    }

    @Nullable
    private static BSLParserRuleContext getPreviousNode(BSLParserRuleContext node, int ruleStatement) {
        List children = node.getParent().children;
        int pos = children.indexOf(node);
        if (pos > 0) {
            for (int i = pos - 1; i >= 0; --i) {
                BSLParserRuleContext prev = (BSLParserRuleContext)children.get(i);
                if (prev.getRuleIndex() != ruleStatement) continue;
                return prev;
            }
        }
        return null;
    }

    private static boolean isAssignmentForVar(String varName, BSLParser.AssignmentContext assignment) {
        BSLParser.LValueContext lValue = assignment.lValue();
        if (lValue == null) {
            return false;
        }
        TerminalNode identifier = lValue.IDENTIFIER();
        return identifier != null && identifier.getText().equalsIgnoreCase(varName);
    }

    private static Optional<String> getStringFromNStrCall(Optional<BSLParser.CallParamContext> ctx) {
        Optional<BSLParser.CallParamContext> nstrCallParamCtx = ctx.map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).filter(memberContexts -> memberContexts.size() == 1).map(memberContexts -> (BSLParser.MemberContext)memberContexts.get(0)).map(BSLParser.MemberContext::complexIdentifier).map(BSLParser.ComplexIdentifierContext::globalMethodCall).filter(globalMethodCallContext -> nstrPattern.matcher(globalMethodCallContext.methodName().getText()).matches()).map(BSLParser.GlobalMethodCallContext::doCall).map(BSLParser.DoCallContext::callParamList).filter(callParamListContext -> !callParamListContext.callParam().isEmpty()).map(callParamContexts -> callParamContexts.callParam(0));
        return IncorrectUseOfStrTemplateDiagnostic.getString(nstrCallParamCtx);
    }

    private static boolean variousParams(int usedParamsCount, Matcher matcher) {
        HashSet<Integer> templateParams = new HashSet<Integer>();
        matcher.reset();
        while (matcher.find()) {
            int index;
            String group = matcher.group(1);
            if (group == null) {
                group = matcher.group(2);
            }
            if ((index = Integer.parseInt(group)) > usedParamsCount) {
                return true;
            }
            templateParams.add(index);
        }
        for (int i = 1; i <= usedParamsCount; ++i) {
            if (templateParams.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkMethodCall(BSLParser.MethodCallContext ctx) {
        return false;
    }

    @Override
    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        if (super.checkGlobalMethodCall(ctx) && IncorrectUseOfStrTemplateDiagnostic.paramsAreDifferent(ctx)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
        return false;
    }
}

