/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.BRAINOVERLOAD})
public class MagicDateDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String DEFAULT_AUTHORIZED_DATES = "00010101,00010101000000,000101010000";
    private static final Pattern methodPattern = CaseInsensitivePattern.compile((String)"\u0414\u0430\u0442\u0430|Date");
    private static final Pattern paramPattern = CaseInsensitivePattern.compile((String)"\"[0123]{1}\\d{7}\"|\"[0123]{1}\\d{13}\"");
    private static final Pattern zeroPattern = Pattern.compile("^0+");
    private static final Pattern nonNumberPattern = CaseInsensitivePattern.compile((String)"\\D");
    public static final int MAX_YEAR_BY_1C = 9999;
    @DiagnosticParameter(type=String.class, defaultValue="00010101,00010101000000,000101010000")
    private final Set<String> authorizedDates = new HashSet<String>(Arrays.asList("00010101,00010101000000,000101010000".split(",")));

    @Override
    public void configure(Map<String, Object> configuration) {
        String authorizedDatesString = (String)configuration.getOrDefault("authorizedDates", DEFAULT_AUTHORIZED_DATES);
        Set authD = Arrays.stream(authorizedDatesString.split(",")).map(String::trim).collect(Collectors.toSet());
        this.authorizedDates.clear();
        this.authorizedDates.addAll(authD);
    }

    public ParseTree visitConstValue(BSLParser.ConstValueContext ctx) {
        TerminalNode tNode = ctx.DATETIME();
        BSLParser.StringContext sNode = ctx.string();
        if ((tNode != null || sNode != null) && this.isAccepted(ctx)) {
            if (sNode != null && !MagicDateDiagnostic.isValidDate(sNode)) {
                return (ParseTree)this.defaultResult();
            }
            Optional<BSLParser.ExpressionContext> expressionContext = MagicDateDiagnostic.getExpression(Optional.of(ctx));
            if (!(MagicDateDiagnostic.insideSimpleDateAssignment(expressionContext) || MagicDateDiagnostic.insideReturnSimpleDate(expressionContext) || MagicDateDiagnostic.insideAssignmentWithDateMethodForSimpleDate(expressionContext))) {
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(ctx.getText()));
            }
        }
        return (ParseTree)this.defaultResult();
    }

    private static boolean isValidDate(BSLParser.StringContext ctx) {
        String text = ctx.getText();
        if (!paramPattern.matcher(text).matches()) {
            return false;
        }
        String strDate = text.substring(1, text.length() - 1);
        return MagicDateDiagnostic.isValidDate(strDate);
    }

    private static boolean isValidDate(String strDate) {
        int year = MagicDateDiagnostic.parseInt(strDate.substring(0, 4));
        if (year < 1 || year > 9999) {
            return false;
        }
        int month = MagicDateDiagnostic.parseInt(strDate.substring(4, 6));
        int day = MagicDateDiagnostic.parseInt(strDate.substring(6, 8));
        if (month < 1 || month > 12 || day < 1 || day > 31) {
            return false;
        }
        if (strDate.length() == 8) {
            return true;
        }
        int hh = MagicDateDiagnostic.parseInt(strDate.substring(8, 10));
        int mm = MagicDateDiagnostic.parseInt(strDate.substring(10, 12));
        int ss = MagicDateDiagnostic.parseInt(strDate.substring(12, 14));
        return hh <= 24 && mm <= 60 && ss <= 60;
    }

    private static int parseInt(String text) {
        String s = zeroPattern.matcher(text).replaceAll("");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean isAccepted(BSLParser.ConstValueContext ctx) {
        String text = ctx.getText();
        return text != null && !text.isEmpty() && !this.isExcluded(text);
    }

    private boolean isExcluded(String text) {
        String s = nonNumberPattern.matcher(text).replaceAll("");
        return this.authorizedDates.contains(s);
    }

    private static Optional<BSLParser.ExpressionContext> getExpression(Optional<BSLParser.ConstValueContext> constValue) {
        return constValue.map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).filter(BSLParser.ExpressionContext.class::isInstance).map(BSLParser.ExpressionContext.class::cast);
    }

    private static boolean insideSimpleDateAssignment(Optional<BSLParser.ExpressionContext> expression) {
        return MagicDateDiagnostic.insideContext(expression, BSLParser.AssignmentContext.class);
    }

    private static boolean insideContext(Optional<BSLParser.ExpressionContext> expression, Class<? extends BSLParserRuleContext> assignmentContextClass) {
        return expression.map(BSLParserRuleContext::getParent).filter(assignmentContextClass::isInstance).isPresent();
    }

    private static boolean insideReturnSimpleDate(Optional<BSLParser.ExpressionContext> expression) {
        return MagicDateDiagnostic.insideContext(expression, BSLParser.ReturnStatementContext.class);
    }

    private static boolean insideAssignmentWithDateMethodForSimpleDate(Optional<BSLParser.ExpressionContext> expression) {
        return expression.map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).map(BSLParserRuleContext::getParent).filter(BSLParser.GlobalMethodCallContext.class::isInstance).map(BSLParser.GlobalMethodCallContext.class::cast).filter(context -> methodPattern.matcher(context.methodName().getText()).matches()).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(BSLParser.AssignmentContext.class::isInstance).isPresent();
    }
}

