/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class MissingSpaceDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    private static final String DEFAULT_LIST_FOR_CHECK_LEFT = "";
    private static final String DEFAULT_LIST_FOR_CHECK_RIGHT = ", ;";
    private static final String DEFAULT_LIST_FOR_CHECK_LEFT_AND_RIGHT = "+ - * / = % < > <> <= >=";
    private static final boolean DEFAULT_CHECK_SPACE_TO_RIGHT_OF_UNARY = false;
    private static final boolean DEFAULT_ALLOW_MULTIPLE_COMMAS = false;
    private static final String UNARY = "+ - * / = % < > ( [ , \u0412\u043e\u0437\u0432\u0440\u0430\u0442 Return <> <= >=";
    private static final Set<Integer> KEYWORDS_WITH_LEFT_RIGHT_SPACE = MissingSpaceDiagnostic.computeKeywordsWithLeftRightSpace();
    private static final Set<Integer> KEYWORDS_WITH_LEFT_SPACE = MissingSpaceDiagnostic.computeKeywordsWithLeftSpace();
    private static final Set<Integer> KEYWORDS_WITH_RIGHT_SPACE = MissingSpaceDiagnostic.computeKeywordsWithRightSpace();
    @DiagnosticParameter(type=String.class, defaultValue="")
    private String listForCheckLeft = "";
    @DiagnosticParameter(type=String.class, defaultValue=", ;")
    private String listForCheckRight = ", ;";
    @DiagnosticParameter(type=String.class, defaultValue="+ - * / = % < > <> <= >=")
    private String listForCheckLeftAndRight = "+ - * / = % < > <> <= >=";
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean checkSpaceToRightOfUnary = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean allowMultipleCommas = false;
    private String mainMessage;
    private String indexWordLeftMsg;
    private String indexWordRightMsg;
    private String indexWordLeftRightMsg;
    private Set<String> setL = Set.of(this.listForCheckLeft.split(" "));
    private Set<String> setR = Set.of(this.listForCheckRight.split(" "));
    private Set<String> setLR = Set.of(this.listForCheckLeftAndRight.split(" "));
    private final Set<String> setUnary = Set.of("+ - * / = % < > ( [ , \u0412\u043e\u0437\u0432\u0440\u0430\u0442 Return <> <= >=".split(" "));
    private final StringInterner stringInterner;

    @Override
    public void check() {
        this.mainMessage = this.info.getMessage();
        this.indexWordLeftMsg = this.info.getResourceString("wordLeft");
        this.indexWordRightMsg = this.info.getResourceString("wordRight");
        this.indexWordLeftRightMsg = this.info.getResourceString("wordLeftAndRight");
        List<Token> tokens = this.documentContext.getTokens();
        for (Token token : tokens) {
            boolean leftComputed = false;
            boolean rightComputed = false;
            boolean noSpaceLeft = false;
            boolean noSpaceRight = false;
            String tokenText = token.getText();
            if ((this.setL.contains(tokenText) || KEYWORDS_WITH_LEFT_SPACE.contains(token.getType())) && (noSpaceLeft = MissingSpaceDiagnostic.noSpaceLeft(tokens, token))) {
                leftComputed = true;
                this.addDiagnostic(token, this.mainMessage, this.indexWordLeftMsg);
            }
            if ((this.setR.contains(tokenText) || KEYWORDS_WITH_RIGHT_SPACE.contains(token.getType())) && (noSpaceRight = this.noSpaceRight(tokens, token))) {
                rightComputed = true;
                this.addDiagnostic(token, this.mainMessage, this.indexWordRightMsg);
            }
            if (!this.setLR.contains(tokenText) && !KEYWORDS_WITH_LEFT_RIGHT_SPACE.contains(token.getType())) continue;
            if (!leftComputed) {
                noSpaceLeft = MissingSpaceDiagnostic.noSpaceLeft(tokens, token);
            }
            if (!rightComputed) {
                noSpaceRight = this.noSpaceRight(tokens, token);
            }
            this.addDiagnosticLeftRight(token, noSpaceLeft, noSpaceRight);
        }
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        this.setL = Set.of(this.listForCheckLeft.split(" "));
        this.setR = Set.of(this.listForCheckRight.split(" "));
        this.setLR = Set.of(this.listForCheckLeftAndRight.split(" "));
    }

    @Override
    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        diagnostics.forEach(diagnostic -> {
            TextEdit textEdit;
            String diagnosticMessage = diagnostic.getMessage().toLowerCase(Locale.ENGLISH);
            boolean missedLeft = diagnosticMessage.contains("\u0441\u043b\u0435\u0432\u0430") || diagnosticMessage.contains("left");
            boolean missedRight = diagnosticMessage.contains("\u0441\u043f\u0440\u0430\u0432\u0430") || diagnosticMessage.contains("right");
            Range range = diagnostic.getRange();
            if (missedLeft) {
                textEdit = new TextEdit(new Range(range.getStart(), range.getStart()), " ");
                textEdits.add(textEdit);
            }
            if (missedRight) {
                textEdit = new TextEdit(new Range(range.getEnd(), range.getEnd()), " ");
                textEdits.add(textEdit);
            }
        });
        return CodeActionProvider.createCodeActions(textEdits, this.info.getResourceString("quickFixMessage"), documentContext.getUri(), diagnostics);
    }

    private void addDiagnostic(Token t, String mainMessage, String errorMessage) {
        this.diagnosticStorage.addDiagnostic(t, this.getErrorMessage(mainMessage, errorMessage, t.getText()));
    }

    private void addDiagnosticLeftRight(Token token, boolean noSpaceLeft, boolean noSpaceRight) {
        String errorMessage;
        if (noSpaceLeft && !noSpaceRight) {
            errorMessage = this.indexWordLeftMsg;
        } else if (noSpaceLeft) {
            errorMessage = this.indexWordLeftRightMsg;
        } else if (noSpaceRight) {
            errorMessage = this.indexWordRightMsg;
        } else {
            return;
        }
        this.addDiagnostic(token, this.mainMessage, errorMessage);
    }

    private static boolean noSpaceLeft(List<Token> tokens, Token t) {
        Token previousToken = tokens.get(t.getTokenIndex() - 1);
        return previousToken.getType() != 6 && !StringUtils.isWhitespace((CharSequence)previousToken.getText());
    }

    private boolean noSpaceRight(List<Token> tokens, Token t) {
        if (!this.checkSpaceToRightOfUnary && (t.getType() == 12 || t.getType() == 13) && this.isUnaryChar(tokens, t)) {
            return false;
        }
        if (tokens.size() > t.getTokenIndex() + 1) {
            Token nextToken = tokens.get(t.getTokenIndex() + 1);
            if (nextToken.getType() == -1) {
                return false;
            }
            if (!this.allowMultipleCommas || t.getType() != 10 || nextToken.getType() != 10) {
                return !StringUtils.isWhitespace((CharSequence)nextToken.getText());
            }
        }
        return false;
    }

    private boolean isUnaryChar(List<Token> tokens, Token t) {
        for (int currentIndex = t.getTokenIndex() - 1; currentIndex > 0; --currentIndex) {
            if (StringUtils.isWhitespace((CharSequence)tokens.get(currentIndex).getText())) continue;
            return this.setUnary.contains(tokens.get(currentIndex).getText());
        }
        return true;
    }

    private String getErrorMessage(String formatString, String errorMessage, String tokenText) {
        return this.stringInterner.intern(String.format(formatString, errorMessage, tokenText));
    }

    private static Set<Integer> computeKeywordsWithLeftRightSpace() {
        return Set.of(Integer.valueOf(56), Integer.valueOf(58), Integer.valueOf(67), Integer.valueOf(68));
    }

    private static Set<Integer> computeKeywordsWithLeftSpace() {
        return Set.of(Integer.valueOf(45), Integer.valueOf(52), Integer.valueOf(54));
    }

    private static Set<Integer> computeKeywordsWithRightSpace() {
        return Set.of(Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(53), Integer.valueOf(55), Integer.valueOf(66), Integer.valueOf(57));
    }

    @ConstructorProperties(value={"stringInterner"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MissingSpaceDiagnostic(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }
}

