/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=2, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.BADPRACTICE})
public class NestedFunctionInParametersDiagnostic
extends AbstractVisitorDiagnostic {
    private static final boolean DEFAULT_ALLOW_ONELINER = true;
    private static final String ALLOWED_METHOD_NAMES = "\u041d\u0421\u0442\u0440,NStr,\u041f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435,PredefinedValue";
    private Pattern allowedMethodNamesPattern = NestedFunctionInParametersDiagnostic.compilePattern("\u041d\u0421\u0442\u0440,NStr,\u041f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435,PredefinedValue");
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean allowOneliner = true;
    @DiagnosticParameter(type=String.class, defaultValue="\u041d\u0421\u0442\u0440,NStr,\u041f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435,PredefinedValue")
    private String allowedMethodNames = "\u041d\u0421\u0442\u0440,NStr,\u041f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435,PredefinedValue";

    private static Pattern compilePattern(String allowedNames) {
        return CaseInsensitivePattern.compile((String)("^(" + allowedNames.replace(" ", "").replace(",", "|") + ")"));
    }

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        this.checkMethodCall((BSLParserRuleContext)ctx, ctx.doCall(), ctx.methodName());
        return (ParseTree)super.visitMethodCall(ctx);
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        this.allowedMethodNamesPattern = NestedFunctionInParametersDiagnostic.compilePattern(this.allowedMethodNames);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        this.checkMethodCall((BSLParserRuleContext)ctx, ctx.doCall(), ctx.methodName());
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        if (!this.findNestedCall((BSLParserRuleContext)ctx, ctx.doCall())) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        if (ctx.typeName() != null) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.typeName(), this.info.getMessage(this.info.getResourceString("diagnosticMessageConstructor"), ctx.typeName().getText()));
        } else {
            this.diagnosticStorage.addDiagnostic(ctx.getStart(), this.info.getResourceString("diagnosticMessageWithoutName", this.info.getResourceString("diagnosticMessageConstructor")));
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private boolean findNestedCall(BSLParserRuleContext ctx, BSLParser.DoCallContext ctxDoCall) {
        if (ctx.getStart().getLine() == ctx.getStop().getLine()) {
            return false;
        }
        if (NestedFunctionInParametersDiagnostic.emptyCallParameterList(ctxDoCall)) {
            return false;
        }
        return this.containsForbiddenMethod((ParseTree)ctxDoCall) && this.multilineParam(ctxDoCall);
    }

    private boolean multilineParam(BSLParser.DoCallContext ctxDoCall) {
        return !this.allowOneliner || ctxDoCall.callParamList().callParam().stream().anyMatch(callParamContext -> callParamContext.getStop().getLine() > callParamContext.getStart().getLine());
    }

    private void checkMethodCall(BSLParserRuleContext ctx, BSLParser.DoCallContext ctxDoCall, BSLParser.MethodNameContext ctxMethodName) {
        if (this.findNestedCall(ctx, ctxDoCall)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctxMethodName, this.info.getMessage(this.info.getResourceString("diagnosticMessageMethod"), ctxMethodName.getText()));
        }
    }

    private boolean containsForbiddenMethod(ParseTree t) {
        boolean needReturn = false;
        if (t instanceof ParserRuleContext) {
            if (92 == ((ParserRuleContext)t).getRuleIndex()) {
                needReturn = true;
            } else if (90 == ((ParserRuleContext)t).getRuleIndex()) {
                needReturn = !NestedFunctionInParametersDiagnostic.emptyCallParameterList(((BSLParser.NewExpressionContext)t).doCall());
            } else if (93 == ((ParserRuleContext)t).getRuleIndex()) {
                boolean bl = needReturn = !this.allowedMethodNamesPattern.matcher(((BSLParser.GlobalMethodCallContext)t).methodName().getText()).matches();
            }
        }
        if (needReturn) {
            return true;
        }
        return IntStream.range(0, t.getChildCount()).anyMatch(i -> this.containsForbiddenMethod(t.getChild(i)));
    }

    private static boolean emptyCallParameterList(@Nullable BSLParser.DoCallContext ctxDoCall) {
        return ctxDoCall == null || ctxDoCall.callParamList() == null || ctxDoCall.callParamList().isEmpty();
    }
}

