/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Regions;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, scope=DiagnosticScope.BSL, minutesToFix=1, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_1, tags={DiagnosticTag.STANDARD})
public class NonStandardRegionDiagnostic
extends AbstractDiagnostic {
    private static final Map<ModuleType, Set<Pattern>> standardRegionsByModuleType = NonStandardRegionDiagnostic.makeStandardRegions();

    private static Map<ModuleType, Set<Pattern>> makeStandardRegions() {
        EnumMap<ModuleType, Set<Pattern>> standardRegions = new EnumMap<ModuleType, Set<Pattern>>(ModuleType.class);
        for (ModuleType moduleType : ModuleType.values()) {
            standardRegions.put(moduleType, Regions.getStandardRegionsPatternsByModuleType(moduleType));
        }
        return standardRegions;
    }

    @Override
    public void check() {
        Set standardRegions = standardRegionsByModuleType.getOrDefault(this.documentContext.getModuleType(), Collections.emptySet());
        if (standardRegions.isEmpty()) {
            return;
        }
        List<RegionSymbol> regions = this.documentContext.getSymbolTree().getModuleLevelRegions();
        if (regions.isEmpty()) {
            return;
        }
        regions.forEach(region -> {
            if (standardRegions.stream().noneMatch(regionName -> regionName.matcher(region.getName()).find())) {
                this.diagnosticStorage.addDiagnostic(region.getStartRange(), this.info.getMessage(region.getName()));
            }
        });
    }
}

