/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, scope=DiagnosticScope.ALL, minutesToFix=10, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD})
public class NumberOfValuesInStructureConstructorDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_VALUES_COUNT = 3;
    @DiagnosticParameter(type=Integer.class, defaultValue="3")
    private int maxValuesCount = 3;

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        if (ctx.typeName() == null) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        if (!DiagnosticHelper.isStructureType((ParseTree)ctx.typeName()) && !DiagnosticHelper.isFixedStructureType((ParseTree)ctx.typeName())) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        BSLParser.DoCallContext doCallContext = ctx.doCall();
        if (doCallContext != null && doCallContext.callParamList().callParam().size() > this.maxValuesCount + 1) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }
}

