/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Module;
import com.github._1c_syntax.bsl.mdo.ModuleOwner;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.Optional;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.SUSPICIOUS}, modules={ModuleType.SessionModule}, scope=DiagnosticScope.BSL, canLocateOnProject=true)
public class ProtectedModuleDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    @Override
    protected void check() {
        CF configuration = this.documentContext.getServerContext().getConfiguration();
        if (configuration.getConfigurationSource() == ConfigurationSource.EMPTY) {
            return;
        }
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty(this.diagnosticRange)) {
            return;
        }
        configuration.getChildren().stream().filter(md -> md instanceof ModuleOwner).map(md -> (ModuleOwner)md).forEach(moduleOwner -> {
            Optional<Module> hasProtected = moduleOwner.getModules().stream().filter(Module::isProtected).findAny();
            if (hasProtected.isPresent()) {
                this.addDiagnostic((ModuleOwner)moduleOwner);
            }
        });
    }

    private void addDiagnostic(ModuleOwner moduleOwner) {
        String ownerMDOName = MdoRefBuilder.getLocaleOwnerMdoName(this.documentContext, (MD)moduleOwner);
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(ownerMDOName));
    }
}

