/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.BADPRACTICE, DiagnosticTag.UNUSED}, modules={ModuleType.CommandModule, ModuleType.CommonModule, ModuleType.ManagerModule, ModuleType.ValueManagerModule, ModuleType.SessionModule, ModuleType.UNKNOWN})
public class UnusedLocalVariableDiagnostic
extends AbstractDiagnostic {
    private final ReferenceIndex referenceIndex;
    private static final Set<VariableKind> CHECKING_VARIABLE_KINDS = EnumSet.of(VariableKind.MODULE, VariableKind.LOCAL, VariableKind.DYNAMIC);

    @Override
    public void check() {
        this.documentContext.getSymbolTree().getVariables().stream().filter(variable -> CHECKING_VARIABLE_KINDS.contains((Object)variable.getKind())).filter(variable -> !variable.isExport()).filter(variable -> this.referenceIndex.getReferencesTo((SourceDefinedSymbol)variable).stream().filter(ref -> ref.getOccurrenceType() == OccurrenceType.REFERENCE).findFirst().isEmpty()).forEach(variable -> this.diagnosticStorage.addDiagnostic(variable.getSelectionRange(), this.info.getMessage(variable.getName())));
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UnusedLocalVariableDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }
}

