/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdclasses.Configuration;
import com.github._1c_syntax.bsl.mdo.support.UseMode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, minutesToFix=15, tags={DiagnosticTag.STANDARD}, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_3)
public class UsingModalWindowsDiagnostic
extends AbstractVisitorDiagnostic {
    private final Pattern modalityMethods = CaseInsensitivePattern.compile((String)"(\u0412\u041e\u041f\u0420\u041e\u0421|DOQUERYBOX|\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0424\u041e\u0420\u041c\u0423\u041c\u041e\u0414\u0410\u041b\u042c\u041d\u041e|OPENFORMMODAL|\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415|OPENVALUE|\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415|DOMESSAGEBOX|\u0412\u0412\u0415\u0421\u0422\u0418\u0414\u0410\u0422\u0423|INPUTDATE|\u0412\u0412\u0415\u0421\u0422\u0418\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415|INPUTVALUE|\u0412\u0412\u0415\u0421\u0422\u0418\u0421\u0422\u0420\u041e\u041a\u0423|INPUTSTRING|\u0412\u0412\u0415\u0421\u0422\u0418\u0427\u0418\u0421\u041b\u041e|INPUTNUMBER|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0412\u041d\u0415\u0428\u041d\u042e\u042e\u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u0423|INSTALLADDIN|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418|INSTALLFILESYSTEMEXTENSION|\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419|INSTALLCRYPTOEXTENSION|\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b|PUTFILE)");
    private final HashMap<String, String> pairMethods = new HashMap();
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean forceModalityMode;

    public UsingModalWindowsDiagnostic() {
        this.pairMethods.put("\u0412\u041e\u041f\u0420\u041e\u0421", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u043e\u043f\u0440\u043e\u0441");
        this.pairMethods.put("DOQUERYBOX", "ShowQueryBox");
        this.pairMethods.put("\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0424\u041e\u0420\u041c\u0423\u041c\u041e\u0414\u0410\u041b\u042c\u041d\u041e", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c\u0424\u043e\u0440\u043c\u0443");
        this.pairMethods.put("OPENFORMMODAL", "OpenForm");
        this.pairMethods.put("\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.pairMethods.put("OPENVALUE", "ShowValue");
        this.pairMethods.put("\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435");
        this.pairMethods.put("DOMESSAGEBOX", "ShowMessageBox");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0414\u0410\u0422\u0423", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0414\u0430\u0442\u044b");
        this.pairMethods.put("INPUTDATE", "ShowInputDate");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        this.pairMethods.put("INPUTVALUE", "ShowInputValue");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0421\u0422\u0420\u041e\u041a\u0423", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0421\u0442\u0440\u043e\u043a\u0438");
        this.pairMethods.put("INPUTSTRING", "ShowInputString");
        this.pairMethods.put("\u0412\u0412\u0415\u0421\u0422\u0418\u0427\u0418\u0421\u041b\u041e", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c\u0412\u0432\u043e\u0434\u0427\u0438\u0441\u043b\u0430");
        this.pairMethods.put("INPUTNUMBER", "ShowInputNumber");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0412\u041d\u0415\u0428\u041d\u042e\u042e\u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u0423", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0412\u043d\u0435\u0448\u043d\u0435\u0439\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
        this.pairMethods.put("INSTALLADDIN", "BeginInstallAddIn");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u0424\u0430\u0439\u043b\u0430\u043c\u0438");
        this.pairMethods.put("INSTALLFILESYSTEMEXTENSION", "BeginInstallFileSystemExtension");
        this.pairMethods.put("\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u0418\u0422\u042c\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419", "\u041d\u0430\u0447\u0430\u0442\u044c\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f\u0420\u0430\u0431\u043e\u0442\u044b\u0421\u041a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0435\u0439");
        this.pairMethods.put("INSTALLCRYPTOEXTENSION", "BeginInstallCryptoExtension");
        this.pairMethods.put("\u041f\u041e\u041c\u0415\u0421\u0422\u0418\u0422\u042c\u0424\u0410\u0419\u041b", "\u041d\u0430\u0447\u0430\u0442\u044c\u041f\u043e\u043c\u0435\u0449\u0435\u043d\u0438\u0435\u0424\u0430\u0439\u043b\u0430");
        this.pairMethods.put("PUTFILE", "BeginPutFile");
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        Configuration cf;
        CF configuration = this.documentContext.getServerContext().getConfiguration();
        if (!this.forceModalityMode && configuration instanceof Configuration && (cf = (Configuration)configuration).getModalityUseMode() == UseMode.USE) {
            return ctx;
        }
        return (ParseTree)super.visitFile(ctx);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        String methodName = ctx.methodName().getText();
        if (this.modalityMethods.matcher(methodName).matches()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(methodName, this.pairMethods.get(methodName.toUpperCase(Locale.ENGLISH))));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }
}

