/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.folding;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.folding.FoldingRangeSupplier;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.FoldingRange;

public abstract class AbstractCommentFoldingRangeSupplier
implements FoldingRangeSupplier {
    @Override
    public List<FoldingRange> getFoldingRanges(DocumentContext documentContext) {
        ArrayList<FoldingRange> foldingRanges = new ArrayList<FoldingRange>();
        List<Token> comments = this.getComments(documentContext);
        int lastRangeStart = -1;
        int previousLine = -1;
        for (Token token : comments) {
            int tokenLine = token.getLine();
            if (tokenLine != previousLine + 1) {
                if (lastRangeStart != previousLine) {
                    FoldingRange foldingRange = new FoldingRange(lastRangeStart - 1, previousLine - 1);
                    foldingRange.setKind("comment");
                    foldingRanges.add(foldingRange);
                }
                lastRangeStart = tokenLine;
            }
            previousLine = tokenLine;
        }
        if (lastRangeStart != previousLine) {
            FoldingRange foldingRange = new FoldingRange(lastRangeStart - 1, previousLine - 1);
            foldingRange.setKind("comment");
            foldingRanges.add(foldingRange);
        }
        return foldingRanges;
    }

    protected abstract List<Token> getComments(DocumentContext var1);
}

