/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableDescription;
import com.github._1c_syntax.bsl.languageserver.hover.DescriptionFormatter;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.StringJoiner;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public class VariableSymbolMarkupContentBuilder
implements MarkupContentBuilder<VariableSymbol> {
    private static final String VARIABLE_KEY = "var";
    private static final String EXPORT_KEY = "export";
    private final LanguageServerConfiguration configuration;
    private final DescriptionFormatter descriptionFormatter;

    @Override
    public MarkupContent getContent(VariableSymbol symbol) {
        StringJoiner markupBuilder = new StringJoiner("\n");
        String signature = this.descriptionFormatter.getSignature(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, signature);
        String location = this.descriptionFormatter.getLocation(symbol);
        this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, location);
        symbol.getDescription().map(VariableDescription::getPurposeDescription).ifPresent(description -> this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, (String)description));
        symbol.getDescription().flatMap(VariableDescription::getTrailingDescription).map(VariableDescription::getPurposeDescription).ifPresent(trailingDescription -> this.descriptionFormatter.addSectionIfNotEmpty(markupBuilder, (String)trailingDescription));
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public SymbolKind getSymbolKind() {
        return SymbolKind.Variable;
    }

    @ConstructorProperties(value={"configuration", "descriptionFormatter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VariableSymbolMarkupContentBuilder(LanguageServerConfiguration configuration, DescriptionFormatter descriptionFormatter) {
        this.configuration = configuration;
        this.descriptionFormatter = descriptionFormatter;
    }
}

