/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableKind;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public final class DocumentSymbolProvider {
    public static final String LABEL = "BSL Language Server";
    private static final Set<VariableKind> supportedVariableKinds = EnumSet.of(VariableKind.MODULE, VariableKind.LOCAL, VariableKind.GLOBAL);

    public List<DocumentSymbol> getDocumentSymbols(DocumentContext documentContext) {
        return documentContext.getSymbolTree().getChildren().stream().filter(DocumentSymbolProvider::isSupported).map(DocumentSymbolProvider::toDocumentSymbol).collect(Collectors.toList());
    }

    private static DocumentSymbol toDocumentSymbol(SourceDefinedSymbol symbol) {
        DocumentSymbol documentSymbol = new DocumentSymbol(symbol.getName(), symbol.getSymbolKind(), symbol.getRange(), symbol.getSelectionRange());
        List children = symbol.getChildren().stream().filter(DocumentSymbolProvider::isSupported).map(DocumentSymbolProvider::toDocumentSymbol).collect(Collectors.toList());
        documentSymbol.setTags(symbol.getTags());
        documentSymbol.setChildren(children);
        return documentSymbol;
    }

    public static boolean isSupported(Symbol symbol) {
        SymbolKind symbolKind = symbol.getSymbolKind();
        if (symbolKind == SymbolKind.Variable) {
            return supportedVariableKinds.contains((Object)((VariableSymbol)symbol).getKind());
        }
        return true;
    }
}

