/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.inlayhints.InlayHintSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.InlayHintWorkspaceCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class InlayHintProvider {
    @Qualifier(value="enabledInlayHintSuppliers")
    private final ObjectProvider<List<InlayHintSupplier>> enabledInlayHintSuppliersProvider;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private final LanguageClientHolder clientHolder;
    private List<InlayHintSupplier> enabledInlayHintSuppliers;

    @PostConstruct
    protected void init() {
        this.enabledInlayHintSuppliers = (List)this.enabledInlayHintSuppliersProvider.getObject();
    }

    public List<InlayHint> getInlayHint(DocumentContext documentContext, InlayHintParams params) {
        return this.enabledInlayHintSuppliers.stream().map(supplier -> supplier.getInlayHints(documentContext, params)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @EventListener
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
        this.enabledInlayHintSuppliers = (List)this.enabledInlayHintSuppliersProvider.getObject();
        this.refreshInlayHints();
    }

    public void refreshInlayHints() {
        boolean refreshSupport = this.clientCapabilitiesHolder.getCapabilities().map(ClientCapabilities::getWorkspace).map(WorkspaceClientCapabilities::getInlayHint).map(InlayHintWorkspaceCapabilities::getRefreshSupport).orElse(Boolean.FALSE);
        if (refreshSupport) {
            this.clientHolder.execIfConnected(LanguageClient::refreshInlayHints);
        }
    }

    @ConstructorProperties(value={"enabledInlayHintSuppliersProvider", "clientCapabilitiesHolder", "clientHolder"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InlayHintProvider(@Qualifier(value="enabledInlayHintSuppliers") ObjectProvider<List<InlayHintSupplier>> enabledInlayHintSuppliersProvider, ClientCapabilitiesHolder clientCapabilitiesHolder, LanguageClientHolder clientHolder) {
        this.enabledInlayHintSuppliersProvider = enabledInlayHintSuppliersProvider;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
        this.clientHolder = clientHolder;
    }
}

