/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.recognizer;

public abstract class AbstractDetector {
    private final double probability;

    public AbstractDetector(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability should be between [0 .. 1]");
        }
        this.probability = probability;
    }

    abstract int scan(String var1);

    final double detect(String line) {
        int matchers = this.scan(line);
        if (matchers == 0) {
            return 0.0;
        }
        return 1.0 - Math.pow(1.0 - this.probability, matchers);
    }
}

