/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.recognizer;

import com.github._1c_syntax.bsl.languageserver.recognizer.AbstractDetector;

public class EndWithDetector
extends AbstractDetector {
    private final char[] endOfLines;

    public EndWithDetector(double probability, char ... endOfLines) {
        super(probability);
        this.endOfLines = (char[])endOfLines.clone();
    }

    @Override
    int scan(String line) {
        for (int index = line.length() - 1; index >= 0; --index) {
            char character = line.charAt(index);
            for (char endOfLine : this.endOfLines) {
                if (character != endOfLine) continue;
                return 1;
            }
            if (Character.isWhitespace(character)) continue;
            return 0;
        }
        return 0;
    }
}

