/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.events.DocumentContextContentChangedEvent;
import com.github._1c_syntax.bsl.languageserver.context.events.ServerContextPopulatedEvent;
import com.github._1c_syntax.bsl.languageserver.context.symbol.AnnotationParamSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.AnnotationSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceFinder;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.Methods;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class AnnotationReferenceFinder
implements ReferenceFinder {
    private final ServerContext serverContext;
    private final Map<String, AnnotationSymbol> registeredAnnotations = new ConcurrentHashMap<String, AnnotationSymbol>();

    @EventListener
    public void handleContextRefresh(ServerContextPopulatedEvent event) {
        this.registeredAnnotations.clear();
        this.serverContext.getDocuments().values().forEach(this::findAndRegisterAnnotation);
    }

    @EventListener
    public void handleDocumentContextChange(DocumentContextContentChangedEvent event) {
        DocumentContext documentContext = event.getSource();
        URI uri = documentContext.getUri();
        this.registeredAnnotations.values().removeIf(annotationSymbol -> annotationSymbol.getOwner().getUri().equals(uri));
        this.findAndRegisterAnnotation(documentContext);
    }

    private void findAndRegisterAnnotation(DocumentContext documentContext) {
        if (documentContext.getFileType() != FileType.OS) {
            return;
        }
        SymbolTree symbolTree = documentContext.getSymbolTree();
        Methods.getOscriptClassConstructor(symbolTree).flatMap(AnnotationReferenceFinder::findAnnotation).map(methodSymbolAnnotationPair -> AnnotationSymbol.from(AnnotationReferenceFinder.getAnnotationName((Annotation)methodSymbolAnnotationPair.getRight()), (MethodSymbol)methodSymbolAnnotationPair.getLeft())).ifPresent(annotationSymbol -> this.registeredAnnotations.put(annotationSymbol.getName(), (AnnotationSymbol)annotationSymbol));
    }

    @Override
    public Optional<Reference> findReference(URI uri, Position position) {
        DocumentContext documentContext = this.serverContext.getDocument(uri);
        if (documentContext == null || documentContext.getFileType() != FileType.OS) {
            return Optional.empty();
        }
        Optional<TerminalNode> maybeTerminalNode = Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)documentContext.getAst(), position);
        if (maybeTerminalNode.isEmpty()) {
            return Optional.empty();
        }
        TerminalNode terminalNode = maybeTerminalNode.get();
        RuleNode parent = terminalNode.getParent();
        if (!(parent instanceof BSLParserRuleContext)) {
            return Optional.empty();
        }
        BSLParserRuleContext parentContext = (BSLParserRuleContext)parent;
        return Optional.of(parentContext).filter(BSLParser.AnnotationNameContext.class::isInstance).map(BSLParser.AnnotationNameContext.class::cast).flatMap(annotationName -> this.getReferenceToAnnotationSymbol(uri, (BSLParser.AnnotationNameContext)annotationName, documentContext)).or(() -> Optional.of(parentContext).filter(BSLParser.AnnotationParamNameContext.class::isInstance).map(BSLParser.AnnotationParamNameContext.class::cast).flatMap(annotationParamName -> this.getReferenceToAnnotationParamSymbol((BSLParser.AnnotationParamNameContext)annotationParamName, documentContext))).or(() -> Optional.of(parentContext).filter(BSLParser.ConstValueContext.class::isInstance).map(BSLParser.ConstValueContext.class::cast).flatMap(constValue -> this.getReferenceToAnnotationParamSymbol((BSLParser.ConstValueContext)constValue, documentContext))).or(() -> Optional.of(parentContext).map(BSLParserRuleContext::getParent).filter(BSLParser.ConstValueContext.class::isInstance).map(BSLParser.ConstValueContext.class::cast).flatMap(constValue -> this.getReferenceToAnnotationParamSymbol((BSLParser.ConstValueContext)constValue, documentContext))).or(() -> Optional.of(parentContext).map(BSLParserRuleContext::getParent).map(BSLParserRuleContext::getParent).filter(BSLParser.ConstValueContext.class::isInstance).map(BSLParser.ConstValueContext.class::cast).flatMap(constValue -> this.getReferenceToAnnotationParamSymbol((BSLParser.ConstValueContext)constValue, documentContext)));
    }

    private Optional<Reference> getReferenceToAnnotationSymbol(URI uri, BSLParser.AnnotationNameContext annotationName, DocumentContext documentContext) {
        BSLParser.AnnotationContext annotationNode = (BSLParser.AnnotationContext)annotationName.getParent();
        return this.getAnnotationSymbol(annotationName).map(annotationSymbol -> Reference.of(documentContext.getSymbolTree().getModule(), annotationSymbol, new Location(uri.toString(), Ranges.create((ParserRuleContext)annotationNode))));
    }

    private Optional<Reference> getReferenceToAnnotationParamSymbol(BSLParser.AnnotationParamNameContext annotationParamName, DocumentContext documentContext) {
        return Optional.of(annotationParamName).map(BSLParserRuleContext::getParent).map(BSLParser.AnnotationParamContext.class::cast).flatMap(annotationParamContext -> this.getReferenceToAnnotationParam(documentContext, Optional.of(annotationParamContext)));
    }

    private Optional<Reference> getReferenceToAnnotationParamSymbol(BSLParser.ConstValueContext constValue, DocumentContext documentContext) {
        return Optional.of(constValue).map(BSLParserRuleContext::getParent).filter(BSLParser.AnnotationParamContext.class::isInstance).map(BSLParser.AnnotationParamContext.class::cast).flatMap(annotationParamContext -> this.getReferenceToAnnotationParam(documentContext, Optional.of(annotationParamContext)));
    }

    private Optional<AnnotationSymbol> getAnnotationSymbol(BSLParser.AnnotationNameContext annotationNode) {
        String annotationName = annotationNode.getText();
        return Optional.ofNullable(this.registeredAnnotations.get(annotationName));
    }

    private Optional<Reference> getReferenceToAnnotationParam(DocumentContext documentContext, Optional<BSLParser.AnnotationParamContext> annotationParamContext) {
        String annotationParamName = annotationParamContext.map(BSLParser.AnnotationParamContext::annotationParamName).map(BSLParserRuleContext::getText).orElse("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        BSLParserRuleContext annotationParamLocation = annotationParamContext.map(BSLParser.AnnotationParamContext::annotationParamName).map(BSLParserRuleContext.class::cast).or(() -> annotationParamContext.map(BSLParser.AnnotationParamContext::constValue)).orElseThrow();
        return annotationParamContext.map(BSLParserRuleContext::getParent).map(BSLParserRuleContext::getParent).map(BSLParser.AnnotationContext.class::cast).map(BSLParser.AnnotationContext::annotationName).flatMap(this::getAnnotationSymbol).flatMap(AnnotationSymbol::getParent).filter(MethodSymbol.class::isInstance).map(MethodSymbol.class::cast).map(annotationDefinitionMethodSymbol -> AnnotationParamSymbol.from(annotationParamName, annotationDefinitionMethodSymbol)).map(annotationParamSymbol -> Reference.of(documentContext.getSymbolTree().getModule(), annotationParamSymbol, new Location(documentContext.getUri().toString(), Ranges.create((ParserRuleContext)annotationParamLocation))));
    }

    private static Optional<Pair<MethodSymbol, Annotation>> findAnnotation(MethodSymbol methodSymbol) {
        return methodSymbol.getAnnotations().stream().filter(annotation -> annotation.getName().equalsIgnoreCase("\u0410\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u044f")).findFirst().filter(annotation -> annotation.getParameters().size() == 1).map(annotation -> Pair.of((Object)methodSymbol, (Object)annotation));
    }

    private static String getAnnotationName(Annotation annotation) {
        return annotation.getParameters().get(0).getValue();
    }

    @ConstructorProperties(value={"serverContext"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnnotationReferenceFinder(ServerContext serverContext) {
        this.serverContext = serverContext;
    }
}

