/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.CodeQualityReportEntry;
import com.github._1c_syntax.bsl.languageserver.reporters.DiagnosticReporter;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CodeQualityReporter
implements DiagnosticReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeQualityReporter.class);
    private final Map<String, DiagnosticInfo> diagnosticInfosByCode;

    @Override
    public String key() {
        return "code-quality";
    }

    @Override
    public void report(AnalysisInfo analysisInfo, Path outputDir) {
        ArrayList<CodeQualityReportEntry> report = new ArrayList<CodeQualityReportEntry>();
        for (FileInfo fileInfo : analysisInfo.getFileinfos()) {
            for (Diagnostic diagnostic : fileInfo.getDiagnostics()) {
                DiagnosticInfo diagnosticInfo = this.diagnosticInfosByCode.get(DiagnosticCode.getStringValue((Either<String, Integer>)diagnostic.getCode()));
                String path = fileInfo.getPath().toString().replace("\\", "/");
                CodeQualityReportEntry entry = new CodeQualityReportEntry(path, diagnostic, diagnosticInfo);
                report.add(entry);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultIndenter indenter = new DefaultIndenter().withLinefeed("\n");
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        ObjectWriter writer = mapper.writer((PrettyPrinter)printer);
        File reportFile = new File(outputDir.toFile(), "./bsl-code-quality.json");
        writer.writeValue(reportFile, report);
        LOGGER.info("CodeQuality report saved to {}", (Object)reportFile.getAbsolutePath());
    }

    @ConstructorProperties(value={"diagnosticInfosByCode"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeQualityReporter(Map<String, DiagnosticInfo> diagnosticInfosByCode) {
        this.diagnosticInfosByCode = diagnosticInfosByCode;
    }
}

