/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.reporters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.reporters.data.AnalysisInfo;
import com.github._1c_syntax.bsl.languageserver.reporters.data.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class GenericIssueReport {
    private static final Map<DiagnosticType, RuleType> diagnosticTypeRuleTypeMap = Map.of(DiagnosticType.ERROR, RuleType.BUG, DiagnosticType.CODE_SMELL, RuleType.CODE_SMELL, DiagnosticType.SECURITY_HOTSPOT, RuleType.SECURITY_HOTSPOT, DiagnosticType.VULNERABILITY, RuleType.VULNERABILITY);
    @JsonProperty(value="issues")
    private final List<GenericIssueEntry> issues;

    public GenericIssueReport(@JsonProperty(value="issues") List<GenericIssueEntry> issues) {
        this.issues = new ArrayList<GenericIssueEntry>(issues);
    }

    public GenericIssueReport(AnalysisInfo analysisInfo, Map<String, DiagnosticInfo> diagnosticInfos) {
        this.issues = new ArrayList<GenericIssueEntry>();
        for (FileInfo fileInfo : analysisInfo.getFileinfos()) {
            for (Diagnostic diagnostic : fileInfo.getDiagnostics()) {
                GenericIssueEntry entry = new GenericIssueEntry(fileInfo.getPath().toString(), diagnostic, diagnosticInfos.get(DiagnosticCode.getStringValue((Either<String, Integer>)diagnostic.getCode())));
                this.issues.add(entry);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<GenericIssueEntry> getIssues() {
        return this.issues;
    }

    static final class GenericIssueEntry {
        private final String engineId;
        private final String ruleId;
        private final String severity;
        private final RuleType type;
        private final Location primaryLocation;
        private final int effortMinutes;
        private final List<Location> secondaryLocations;

        public GenericIssueEntry(@JsonProperty(value="engineId") String engineId, @JsonProperty(value="ruleId") String ruleId, @JsonProperty(value="severity") String severity, @JsonProperty(value="type") RuleType type, @JsonProperty(value="primaryLocation") Location primaryLocation, @JsonProperty(value="effortMinutes") int effortMinutes, @JsonProperty(value="secondaryLocations") List<Location> secondaryLocations) {
            this.engineId = engineId;
            this.ruleId = ruleId;
            this.severity = severity;
            this.type = type;
            this.primaryLocation = primaryLocation;
            this.effortMinutes = effortMinutes;
            this.secondaryLocations = new ArrayList<Location>(secondaryLocations);
        }

        public GenericIssueEntry(String fileName, Diagnostic diagnostic, DiagnosticInfo diagnosticInfo) {
            this.engineId = diagnostic.getSource();
            this.ruleId = diagnosticInfo.getCode().getStringValue();
            this.severity = diagnosticInfo.getSeverity().name();
            this.type = diagnosticTypeRuleTypeMap.get((Object)diagnosticInfo.getType());
            this.primaryLocation = new Location(fileName, diagnostic);
            this.effortMinutes = diagnosticInfo.getMinutesToFix();
            List relatedInformation = diagnostic.getRelatedInformation();
            this.secondaryLocations = relatedInformation == null ? new ArrayList<Location>() : relatedInformation.stream().map(Location::new).collect(Collectors.toList());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getEngineId() {
            return this.engineId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getRuleId() {
            return this.ruleId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSeverity() {
            return this.severity;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RuleType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Location getPrimaryLocation() {
            return this.primaryLocation;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getEffortMinutes() {
            return this.effortMinutes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<Location> getSecondaryLocations() {
            return this.secondaryLocations;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericIssueEntry)) {
                return false;
            }
            GenericIssueEntry other = (GenericIssueEntry)o;
            if (this.getEffortMinutes() != other.getEffortMinutes()) {
                return false;
            }
            String this$engineId = this.getEngineId();
            String other$engineId = other.getEngineId();
            if (this$engineId == null ? other$engineId != null : !this$engineId.equals(other$engineId)) {
                return false;
            }
            String this$ruleId = this.getRuleId();
            String other$ruleId = other.getRuleId();
            if (this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId)) {
                return false;
            }
            String this$severity = this.getSeverity();
            String other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
                return false;
            }
            RuleType this$type = this.getType();
            RuleType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Location this$primaryLocation = this.getPrimaryLocation();
            Location other$primaryLocation = other.getPrimaryLocation();
            if (this$primaryLocation == null ? other$primaryLocation != null : !((Object)this$primaryLocation).equals(other$primaryLocation)) {
                return false;
            }
            List<Location> this$secondaryLocations = this.getSecondaryLocations();
            List<Location> other$secondaryLocations = other.getSecondaryLocations();
            return !(this$secondaryLocations == null ? other$secondaryLocations != null : !((Object)this$secondaryLocations).equals(other$secondaryLocations));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEffortMinutes();
            String $engineId = this.getEngineId();
            result = result * 59 + ($engineId == null ? 43 : $engineId.hashCode());
            String $ruleId = this.getRuleId();
            result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
            String $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
            RuleType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Location $primaryLocation = this.getPrimaryLocation();
            result = result * 59 + ($primaryLocation == null ? 43 : ((Object)$primaryLocation).hashCode());
            List<Location> $secondaryLocations = this.getSecondaryLocations();
            result = result * 59 + ($secondaryLocations == null ? 43 : ((Object)$secondaryLocations).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GenericIssueReport.GenericIssueEntry(engineId=" + this.getEngineId() + ", ruleId=" + this.getRuleId() + ", severity=" + this.getSeverity() + ", type=" + String.valueOf((Object)this.getType()) + ", primaryLocation=" + String.valueOf(this.getPrimaryLocation()) + ", effortMinutes=" + this.getEffortMinutes() + ", secondaryLocations=" + String.valueOf(this.getSecondaryLocations()) + ")";
        }
    }

    static enum RuleType {
        BUG,
        CODE_SMELL,
        SECURITY_HOTSPOT,
        VULNERABILITY;

    }

    static final class TextRange {
        private final int startLine;
        private final int endLine;
        private final int startColumn;
        private final int endColumn;

        public TextRange(@JsonProperty(value="startLine") int startLine, @JsonProperty(value="endLine") int endLine, @JsonProperty(value="startColumn") int startColumn, @JsonProperty(value="endColumn") int endColumn) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }

        public TextRange(Range range) {
            Position startPosition = range.getStart();
            Position endPosition = range.getEnd();
            this.startLine = startPosition.getLine() + 1;
            this.startColumn = startPosition.getCharacter();
            this.endLine = endPosition.getLine() + 1;
            this.endColumn = endPosition.getCharacter();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getStartLine() {
            return this.startLine;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getEndLine() {
            return this.endLine;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getStartColumn() {
            return this.startColumn;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getEndColumn() {
            return this.endColumn;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextRange)) {
                return false;
            }
            TextRange other = (TextRange)o;
            if (this.getStartLine() != other.getStartLine()) {
                return false;
            }
            if (this.getEndLine() != other.getEndLine()) {
                return false;
            }
            if (this.getStartColumn() != other.getStartColumn()) {
                return false;
            }
            return this.getEndColumn() == other.getEndColumn();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartLine();
            result = result * 59 + this.getEndLine();
            result = result * 59 + this.getStartColumn();
            result = result * 59 + this.getEndColumn();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GenericIssueReport.TextRange(startLine=" + this.getStartLine() + ", endLine=" + this.getEndLine() + ", startColumn=" + this.getStartColumn() + ", endColumn=" + this.getEndColumn() + ")";
        }
    }

    static final class Location {
        private final String message;
        private final String filePath;
        private final TextRange textRange;

        public Location(@JsonProperty(value="message") String message, @JsonProperty(value="filePath") String filePath, @JsonProperty(value="textRange") TextRange textRange) {
            this.message = message;
            this.filePath = filePath;
            this.textRange = textRange;
        }

        public Location(String filePath, Diagnostic diagnostic) {
            this.message = diagnostic.getMessage();
            this.filePath = filePath;
            this.textRange = new TextRange(diagnostic.getRange());
        }

        public Location(DiagnosticRelatedInformation relatedInformation) {
            this.message = relatedInformation.getMessage();
            this.filePath = Paths.get(URI.create(relatedInformation.getLocation().getUri())).toString();
            this.textRange = new TextRange(relatedInformation.getLocation().getRange());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMessage() {
            return this.message;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getFilePath() {
            return this.filePath;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TextRange getTextRange() {
            return this.textRange;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            TextRange this$textRange = this.getTextRange();
            TextRange other$textRange = other.getTextRange();
            return !(this$textRange == null ? other$textRange != null : !((Object)this$textRange).equals(other$textRange));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            TextRange $textRange = this.getTextRange();
            result = result * 59 + ($textRange == null ? 43 : ((Object)$textRange).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GenericIssueReport.Location(message=" + this.getMessage() + ", filePath=" + this.getFilePath() + ", textRange=" + String.valueOf(this.getTextRange()) + ")";
        }
    }
}

